<?php
error_reporting(E_ALL & ~E_WARNING & ~E_CORE_WARNING);
ini_set('display_errors', 0);
ini_set('display_startup_errors', 0);
?>
<!DOCTYPE html>
<html lang="en">

<head>
    
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="color-scheme" content="light dark" />
    <meta name="referrer" content="origin">
    <meta content="<?= $settings['description'] ?>" name="description" />
    <!-- App favicon -->
    <link rel="shortcut icon" href="<?= base_url() ?>assets/images/favicon.ico">

    <!-- ##########  fontawsome ########## -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" />

    <!-- ########## Boxicons ########## -->
    <link href='https://unpkg.com/boxicons@2.1.2/css/boxicons.min.css' rel='stylesheet'>

    <!-- ########## materials icon ##########  -->
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">

    <!-- ##########  bootstrap stylesheet ########## -->
    <link href="<?= base_url() ?>assets/coinzi/bs/css/bootstrap.min.css" rel="stylesheet" crossorigin="anonymous">

    <!-- ########## main stylesheet ########## -->
    <link rel="stylesheet" href="<?= base_url() ?>assets/coinzi/dash/css/mydash.css">
    
    <script src="https://code.jquery.com/jquery-3.7.1.min.js" integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>

    <title><?= $page ?> | <?= $settings['name'] ?> - <?= $settings['description'] ?></title>
    <style>
.telegram-button {
  display: inline-flex; 
  justify-content: center; 
  align-items: center;
  background-color: #0088cc;
  color: #fff; 
  width: 45px; 
  height: 45px;
  border-radius: 50%; 
  text-decoration: none;
  transition: background-color 0.3s ease;
  padding: 10px;
}

.telegram-button:hover {
  background-color: #005580;
}


.telegram-button i {
  font-size: 24px; 
  margin-right: 0;
}
</style>
</head>

<body id="body">
    <div class="wrapper-parent">
        <!-- gradient -->
        <div class="hero-gr-top">
            <img src="<?= base_url() ?>assets/coinzi/dash/img/hero-bg-gradient-top.png" alt="">
        </div>
        <div class="hero-gr-bottom">
            <img src="<?= base_url() ?>assets/coinzi/dash/img/hero-bg-gradient-bottom.png" alt="">
        </div>

        <!-- floating btc -->
        <div class="float-btc">
            <img src="<?= base_url() ?>assets/coinzi/dash/img/floation-btc.png" alt="">
        </div>

        <!-- ########## sidebar menu ########## -->
        <div id="menu" class="menu-wrap hide">
            <!-- # faucet name # -->
            <div class="site-name">
                <a href="<?= site_url() ?>">
                    Coinzi
                </a>
            </div>

            <!-- # Nav List # -->
            <ul class="insideScroll text-white mt-2">
                <li class="hover">
                    <a href="<?= site_url('dashboard') ?>" class="">
                        <div class="icon">
                            <img src="<?= base_url() ?>assets/coinzi/dash/img/dashboard.svg" alt="">
                        </div>

                        Dashboard
                    </a>
                </li>
                <li class="hover">
                    <a href="<?= site_url('daily_streak') ?>" class="">
                        <div class="icon">
                            <img src="<?= base_url() ?>assets/coinzi/dash/img/success_8427585.png" alt="">
                        </div>

                        Daily Streak
                    </a>
                </li>
                <li class="hover">
                    <a href="<?= site_url('referrals') ?>" class="">
                        <div class="icon">
                            <img src="<?= base_url() ?>assets/coinzi/dash/img/referral.svg" alt="">
                        </div>
                        Referral 
                        <span class="menu-pill" ><?= $settings['referral'] ?>%   <i class="fa-solid fa-heart fa-beat" style="--fa-beat-scale: 2.0;"></i> </span>
                        
                       
                    </a>
                     
                </li>
                    <li class="hover">
                        <a href="<?= site_url('referral_milestones') ?>" class="">
                            <div class="icon">
                                <img src="<?= base_url() ?>assets/coinzi/dash/img/referral.svg" alt="">
                            </div>
                            Referral Milestones
                        </a>
                    </li>
                <li class="hover">
                    <a href="<?= site_url('leaderboard') ?>" class="">
                        <div class="icon">
                            <img src="<?= base_url() ?>assets/coinzi/dash/img/leaderboard.svg" alt="">
                        </div>
                        Leaderboard
                    </a>
                </li>
                    
                    <!--
                
                    <li class="hover">
                        <a href="<?= site_url('contest') ?>" class="">
                            <div class="icon">
                                <img src="<?= base_url() ?>assets/coinzi/dash/img/trophy.png">
                            </div>
                            50$ Contest
                            </a>
                    
                    
                    
                     </li>
                     
                     -->
                     
                
                

                <li class="hover">
                    <a href="<?= site_url('withdraw') ?>" class="">
                        <div class="icon">
                            <img src="<?= base_url() ?>assets/coinzi/dash/img/withdraw.svg" alt="">
                        </div>
                        Withdraw
                    </a>
                </li>
                
                <li class="hover">
                    <a href="https://t.me/coinzi_announcements">
                        <div class="icon">
                            <img src="<?= base_url() ?>assets/coinzi/dash/img/telegram.png" alt="">
                        </div>
                        Announcements
                    </a>
                </li>

                

                <li class="title">
                    <p>Earn</p>
                </li>

                <li class="hover">
                    <a href="<?= site_url('surveys') ?>" class="">
                        <div class="icon">
                            <img src="<?= base_url() ?>assets/coinzi/dash/img/survey.svg" alt="">
                        </div>
                        Surveys
                        <span class="menu-pill">New</span>
                    </a>
                </li>
                
                <!--<li class="hover" style="background-color:  rgba(238, 197, 16, 0.3);; border-radius: 10px">-->
                <!--    <a href="https://www.youtube.com/channel/UCdk6FaadL614XkHDYOz72Ww">-->
                <!--        <div class="icon">-->
                <!--            <img src="<?= base_url() ?>assets/coinzi/dash/img/coinz.png" alt="">-->
                <!--        </div>-->
                <!--        How To Earn Coinz ?-->
                <!--    </a>-->
                <!--</li>-->

                <li class="hover" style="background-color:  rgba(24, 215, 36, 0.7);; border-radius: 10px" >
                    <a href="<?= site_url('offerwalls') ?>" class="">
                        <div class="icon">
                            <img src="<?= base_url() ?>assets/coinzi/dash/img/offerwalls.svg" alt="">
                        </div>
                        Offerwalls
                        <span class="menu-pill"> +100%
                          <i class="fa-solid fa-heart fa-beat" style="--fa-beat-scale: 3;">   </i>
                          </span>
                    </a>


                </li>

                <?php if ($settings['ptc_status'] == 'on') { ?>
                    <li class="hover">
                        <a href="<?= site_url('ptc') ?>" class="">
                            <div class="icon">
                                <img src="<?= base_url() ?>assets/coinzi/dash/img/ptc.svg" alt="">
                            </div>
                            PTC
                            <span class="menu-pill"><?= $countAvailableAds ?></span>
                        </a>
                    </li>
                                        <li class="hover">
                        <a href="<?= site_url('extraptc') ?>" class="">
                            <div class="icon">
                                <img src="<?= base_url() ?>assets/coinzi/dash/img/ptc.svg" alt="">
                            </div>
                            Extra PTC
                        </a>
                    </li>
                <?php } ?>

                <?php if ($settings['tasks_status'] == 'on') { ?>
                    <li class="hover">
                        <a href="<?= site_url('tasks') ?>" class="">
                            <div class="icon">
                                <img src="<?= base_url() ?>assets/coinzi/dash/img/task.svg" alt="">
                            </div>
                            Tasks
                            <span class="menu-pill"><?= $countAvailableTasks ?></span>
                        </a>
                    </li>
                <?php } ?>

                <?php if ($settings['coupon_status'] == 'on') { ?>
                    <li class="hover">
                        <a href="<?= site_url('coupon') ?>" class="">
                            <div class="icon">
                                <img src="<?= base_url() ?>assets/coinzi/dash/img/coupon.svg" alt="">
                            </div>
                            Coupon
                        </a>
                    </li>
                <?php } ?>


                <?php if ($settings['achievement_status'] == 'on') { ?>
                    <li class="hover">
                        <a href="<?= site_url('achievements') ?>" class="">
                            <div class="icon">
                                <img src="<?= base_url() ?>assets/coinzi/dash/img/achievement.svg" alt="">
                            </div>
                            Achievement
                        </a>
                    </li>
                <?php } ?>

                <?php if ($settings['autofaucet_status'] == 'on') { ?>
                    <li class="hover">
                        <a href="<?= site_url('auto') ?>" class="">
                            <div class="icon" style="margin-top: -8px;">
                                <img src="<?= base_url() ?>assets/coinzi/dash/img/auto.svg" alt="">
                            </div>
                            Auto Faucet
                        </a>
                    </li>
                <?php } ?>

                <?php if ($settings['faucet_status'] == 'on') { ?>
                    <li class="hover">
                        <a href="<?= site_url('faucet') ?>" class="">
                            <div class="icon">
                                <img src="<?= base_url() ?>assets/coinzi/dash/img/manual.svg" alt="">
                            </div>
                            Manual Faucet
                        </a>
                    </li>
                <?php } ?>

                <?php if ($settings['mad_status'] == 'on') { ?>
                    <li class="hover">
                        <a href="<?= site_url('/madfaucet') ?>" class="">
                            <div class="icon">
                                <img src="<?= base_url() ?>assets/coinzi/dash/img/madf.svg" alt="">
                            </div>
                            Mad Faucet
                        </a>
                    </li>
                <?php } ?>

                <?php if ($settings['wheel_status'] == 'on') { ?>
                    <li class="hover">
                        <a href="<?= site_url('/wheel') ?>" class="">
                            <div class="icon">
                                <img src="<?= base_url() ?>assets/coinzi/dash/img/wheel.svg" alt="">
                            </div>
                            Wheel Of Fortune
                        </a>
                    </li>
                <?php } ?>

                <?php if ($settings['mining_status'] == 'on') { ?>
                    <li class="hover">
                        <a href="<?= site_url('mining') ?>" class="">
                            <div class="icon">
                                <img src="<?= base_url() ?>assets/coinzi/dash/img/mining.svg" alt="">
                            </div>
                            Mining
                        </a>
                    </li>
                <?php } ?>

                <?php if ($settings['shortlink_status'] == 'on') { ?>
                    <li class="hover">
                        <a href="<?= site_url('links') ?>" class="">
                            <div class="icon">
                                <img src="<?= base_url() ?>assets/coinzi/dash/img/links.svg" alt="">
                            </div>
                            Shortlinks
                            <span class="menu-pill"><?= $countAvailableLinks ?></span>
                        </a>
                    </li>
                    <li class="hover">
                        <a href="<?= site_url('extralinks') ?>" class="">
                            <div class="icon">
                                <img src="<?= base_url() ?>assets/coinzi/dash/img/links.svg" alt="">
                            </div>
                            Extra Shortlinks
                        </a>
                    </li>
                <?php } ?>

                <li class="title">
                    <p>Advertise</p>
                </li>

                <li class="hover">
                    <a href="<?= site_url('advertise') ?>" class="">
                        <div class="icon">
                            <img src="<?= base_url() ?>assets/coinzi/dash/img/advertise.svg" alt="">
                        </div>
                        Create Ads
                    </a>
                </li>

                <li class="hover">
                    <a href="<?= site_url('advertise/manage') ?>" class="">
                        <div class="icon">
                            <img src="<?= base_url() ?>assets/coinzi/dash/img/managead.svg" alt="">
                        </div>
                        Manage Ads
                    </a>
                </li>

                <li class="hover">
                    <a href="<?= site_url('deposit') ?>" class="">
                        <div class="icon">
                            <img src="<?= base_url() ?>assets/coinzi/dash/img/deposit.svg" alt="">
                        </div>
                        Deposit
                    </a>
                </li>

                <li class="hover">
                    <a href="<?= site_url('transfer') ?>" class="">
                        <div class="icon">
                            <img src="<?= base_url() ?>assets/coinzi/dash/img/transfer.svg" alt="">
                        </div>
                        Transfer
                    </a>
                </li>

                <li class="title orange">
                    <p>Account</p>
                </li>

                <li class="hover">
                    <a href="<?= site_url('profile') ?>" class="">
                        <div class="icon">
                            <img src="<?= base_url() ?>assets/coinzi/dash/img/profile.svg" alt="">
                        </div>
                        Profile
                    </a>
                </li>

                <li class="hover">
                    <a href="<?= site_url('history') ?>" class="">
                        <div class="icon">
                            <img src="<?= base_url() ?>assets/coinzi/dash/img/history.svg" alt="">
                        </div>
                        History
                    </a>
                </li>

                <li class="hover">
                    <a href="<?= site_url('logout') ?>" class="">
                        <div class="icon">
                            <img src="<?= base_url() ?>assets/coinzi/dash/img/outlog.svg" alt="">
                        </div>
                        Logout
                    </a>
                </li>
            </ul>
        </div>

        <!-- responsive overlay -->
        <div class="responsive-overlay"></div>

        <!-- ########## main content ########## -->
        <div class="content-wrap">
            <!-- top row -->
            <div class="top-bar sticky-top">
                <div class="container-fluid">
                    <div class="row px-4">
                        <div class="col-12 bg">
                            <div class="row">
                                <!-- menu toggler -->
                                <div class="col-6">
                                    <!-- ## hamburger icon ## -->
                                    <div id="hideshow" href="#!" class="menu-toggle-btn">
                                        <img src="<?= base_url() ?>assets/coinzi/dash/img/menu-toggler.svg" alt="">
                                    </div>

                                    <!-- ## hamburger icon responsive ## -->
                                    <div id="hideshow" href="#!" class="menu-toggle-btn lg">
                                        <img src="<?= base_url() ?>assets/coinzi/dash/img/menu-toggler.svg" alt="">
                                    </div>
                                </div>

                                <!-- top row cta -->
                                <div class="col-6 d-flex justify-content-end" id="page-header-notifications-dropdown">
                                    <button class="me-3" id="notifbtn">
                                        <?php if ($countUnreadNotification > 0) { ?>
                                            <i class="fa-solid fa-bell"></i><span class="badge badge-danger badge-pill"><?= $countUnreadNotification ?></span>
                                        <?php } else { ?>
                                            <i class="fa-solid fa-bell"></i>
                                        <?php } ?>
                                    </button>

                                    <div class="notification_drop">
                                        <div class="ntd_header">
                                            <p class="ntd_text">Total Notification</p>
                                            <p><span class="ntd_count"><?= $countUnreadNotification ?></span></p>
                                        </div>

                                        <div class="notifications">
                                            <?php
                                            foreach ($notifications as $notification) {
                                                $icon = [];
                                                switch ($notification['type']) {
                                                    case 0:
                                                        $icon['content'] = '<i class="fas fa-bullhorn"></i>';
                                                        $icon['color'] = 'bg-primary';
                                                        break;
                                                    case 1:
                                                        $icon['content'] = '<i class="far fa-money-bill-alt"></i>';
                                                        $icon['color'] = 'bg-success';
                                                        break;
                                                    case 2:
                                                        $icon['content'] = '<i class="fas fa-exclamation-triangle"></i>';
                                                        $icon['color'] = 'bg-danger';
                                                        break;
                                                    default:
                                                        $icon['content'] = '<i class="far fa-comment-dots"></i>';
                                                        $icon['color'] = 'bg-info';
                                                        break;
                                                }
                                            ?>
                                                <div class="notif">
                                                    <div class="d-flex align-items-center">
                                                        <div class="avatar-xs mr-3">
                                                            <span class="avatar-title <?= $icon['color'] ?> rounded font-size-16 p-2">
                                                                <?= $icon['content'] ?>
                                                            </span>
                                                        </div>
                                                        <div class="ms-2">
                                                            <div class="font-size-12">
                                                                <p class="mb-1" key="t-grammer" style="word-break: keep-all;"><?= $notification['content'] ?></p>
                                                                <p class="mb-0"><i class="mdi mdi-clock-outline"></i> <span key="t-min-ago"><?= timespan($notification["create_time"], time(), 2) ?> ago</span></p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                            <?php } ?>
                                        </div>
                                    </div>
                                 <!-- HTML !-->
<a class="telegram-button" href="https://t.me/coinzi_announcements" target="_blank">
  <i class="fab fa-telegram"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- #### dashboard main content #### -->
            <div class=" main-content">
                <div class="container-fluid">
                    <?php if (!empty($settings['global_notification'])) { ?>
                        <div class="row px-3">
                            <div class="col-12">
                                <div class="notice-bar py-0 mb-4">
<marquee behavior="scroll" direction="left" scrollamount="3" onmouseover="this.stop();" onmouseout="this.start()">
    <h6 class="py-3 marq-text"><i class="fas fa-bullhorn"></i>: <?= $settings['global_notification'] ?></h6>
</marquee>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                    <?= $contents ?>
<!-- Widget container -->
<div id="widget-container" style="display: none; position: fixed; top: 50%; right: 20px; transform: translateY(-50%); width: 300px; height: 400px; z-index: 9999;">

    <!-- Your widget content with scroll system -->
    <div style="overflow-y: auto; height: 100%; width: 100%;" id="multiside"></div>
    
    <!-- Close button -->
    <div id="close-button" onclick="closeWidget()" style="position: absolute; top: 10px; right: 10px; cursor: pointer; z-index: 10000;">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24" fill="black"><path d="M0 0h24v24H0z" fill="none"/><path d="M18 6.83l-1.41-1.41L12 10.59 7.41 6 6 7.41 10.59 12 6 16.59 7.41 18 12 13.41 16.59 18 18 16.59 13.41 12 18 7.41 16.59 6z"/></svg>
    </div>

</div>

                </div>
            </div>
        </div>
    </div>

    <!-- ########## js ########## -->
    <?= $settings['footer_code'] ?>
    <!-- JAVASCRIPT -->
    <script src="<?= base_url() ?>assets/libs/jquery/jquery.min.js"></script>
    <script src="<?= base_url() ?>assets/libs/metismenu/metisMenu.min.js"></script>
    <script src="<?= base_url() ?>assets/libs/node-waves/waves.min.js"></script>
    <script type="module" src="https://unpkg.com/ionicons@7.1.0/dist/ionicons/ionicons.esm.js"></script>
    <script src="<?= base_url() ?>assets/coinzi/bs/js/bootstrap.bundle.min.js" crossorigin="anonymous"></script>
    <script src="<?= base_url() ?>assets/coinzi/dash/js/dashboard.js"></script>
    <script type="text/javascript">
        var site_url = "<?= base_url() ?>";
    </script>
    <!-- App js -->
    <script src="<?= base_url() ?>assets/js/app.js?v=<?= VIE_VERSION ?>"></script>
    <script src="<?= base_url() ?>assets/js/vie/captcha.js?v=<?= VIE_VERSION ?>"></script>
    <?php if ($page == 'Advertise') { ?>
        <script src="<?= base_url() ?>assets/js/vie/advertise.js?v=<?= VIE_VERSION ?>"></script>
    <?php } ?>
    <?php if ($page == 'Deposit') { ?>
        <script src="<?= base_url() ?>assets/js/vie/deposit.js?v=<?= VIE_VERSION ?>"></script>
    <?php } ?>
    <?php if ($page == 'Dice') { ?>
        <script src="<?= base_url() ?>assets/js/vie/dice.js?v=<?= VIE_VERSION ?>"></script>
    <?php } ?>
    <?php if ($page == 'Coin Flip') { ?>
        <script src="<?= site_url('assets/js/vie/coinflip.js?v=' . VIE_VERSION) ?>"></script>
    <?php } ?>
    <script type="text/javascript">
        $("a[href='<?= current_url() ?>']").attr('data-active', 'true');
    </script>
    <?php if (isset($antibot_js)) { ?>
        <?= $antibot_js ?>
        <script src="<?= base_url() ?>assets/js/vie/antibotlinks.js?v=<?= VIE_VERSION ?>"></script>
    <?php } ?>
    <?php if ($page == 'Faucet' || $page == 'Mad Faucet') { ?>
        <script src="<?= base_url() ?>assets/js/vie/faucet.js?v=<?= VIE_VERSION ?>"></script>
    <?php } ?>
    <?php if ($page == 'Wheel of fortunes') { ?>
        <script src="<?= base_url() ?>assets/js/wheel/Winwheel.min.js"></script>
        <script src="<?= base_url() ?>assets/js/wheel/TweenMax.min.js"></script>
        <script src="<?= base_url() ?>assets/js/wheel/wheel.js"></script>
    <?php } ?>
    <?php if (isset($_COOKIE['captcha'])) { ?>
        <script>
            $('option[value=<?= $_COOKIE['captcha'] ?>]').attr('selected', 'selected');
        </script>
    <?php } ?>
    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <?php
    if (isset($_SESSION['sweet_message'])) {
        echo $_SESSION['sweet_message'];
    }
    ?>
    <?php include 'adblock.php'; ?>
    <?php include 'chatbro.php'; ?>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var currentCount = <?= $countUnreadNotification ?>;

            var prevCount = localStorage.getItem('prevCount');

            if (prevCount !== null && currentCount > prevCount) {
                var audio = new Audio('assets/notification.mp3');
                audio.play();
            }

            localStorage.setItem('prevCount', currentCount);
        });
    </script>

<script>
const script2 = {
    div_id: "multiside",
    theme_style: 2,
    order_by: 1,
    display_mode: 3, 
    link: "https://offers.cpx-research.com/index.php?app_id=5878&ext_user_id=9713756",
    newtab: true
};

const config = {
    general_config: {
        app_id: '<?= $this->data['settings']['cpx_app_id'] ?>',
        ext_user_id: "<?= $this->data['user']['id'] ?>",
        email: "<?= $this->data['user']['email'] ?>",
        username: "<?= $this->data['user']['username'] ?>",
        secure_hash: "<?= md5($this->data['user']['id'] . '-' . $this->data['settings']['cpx_hash']) ?>",
    },
    style_config: {
        text_color: "#2b2b2b",
        survey_box: {
            topbar_background_color: "#ae31d1",
            box_background_color: "white",
            rounded_borders: true,
            stars_filled: "#ffaf20",
            stars_empty: "rgb(221 221 221)",
            accent_color_small_box: "#1DA05E",
            place_stars_bottom_small_box: true
        },  
    },
    script_config: [script2],
    debug: false,
    useIFrame: true,
    iFramePosition: 1,
    functions: {
        no_surveys_available: () => {
            console.log("no surveys available function here");
        },
        count_new_surveys: (countsurveys) => {
            console.log("count surveys function here, count:", countsurveys);
        },
        get_all_surveys: (surveys) => {
            console.log("get all surveys function here, surveys: ", surveys);
        },
        get_transaction: (transactions) => {
            console.log("transaction function here, transaction: ", transactions);
        }
    }  
};

window.config = config;

// Function to close the widget
function closeWidget() {
    var widgetContainer = document.getElementById('widget-container');
    widgetContainer.style.display = 'none';
    // Store timestamp when the widget was closed
    localStorage.setItem('widgetClosedAt', Date.now());
}

// Check if the widget should be displayed or not
function checkWidgetStatus() {
    var widgetClosedAt = localStorage.getItem('widgetClosedAt');
    if (!widgetClosedAt) {
        // Widget was never closed before or local storage was cleared
        return true;
    } else {
        // Check if enough time has passed since the widget was closed
        var currentTime = Date.now();
        var timeDifference = currentTime - parseInt(widgetClosedAt);
        // 20 minutes in milliseconds
        var twentyMinutes = 20 * 60 * 1000;
        return timeDifference >= twentyMinutes;
    }
}

// Show or hide the widget based on status
window.onload = function() {
    var shouldDisplayWidget = checkWidgetStatus();
    var widgetContainer = document.getElementById('widget-container');
    if (shouldDisplayWidget) {
        widgetContainer.style.display = 'block';
    }
};
</script>

<script type="text/javascript" src="https://cdn.cpx-research.com/assets/js/script_tag_v2.0.js"></script>     
</body>

</html>