<div class="row g-4 justify-content-center">
    <div class="col-lg-12">
        <div class="dashboard-card p-4 p-md-5">
            <div class="d-flex align-items-center gap-3 mb-4">
                <div class="feature-icon small bg-primary bg-opacity-10">
                    <i class="fas fa-wallet text-gradient"></i>
                </div>
                <div>
                    <h2 class="text-white mb-0">Withdraw Funds</h2>
                    <p class="text-secondary small mb-0">Convert your Coinz into your favorite cryptocurrency.</p>
                </div>
            </div>

            <?php if (isset($_SESSION['message'])) echo $_SESSION['message']; ?>

            <form action="<?= site_url('withdraw/withdraw') ?>" method="POST" autocomplete="off" id="withdraw-form">
                <input type="hidden" name="<?= $csrf_name ?>" value="<?= $csrf_hash ?>">

                <!-- Currency Selection -->
                <div class="mb-5">
                    <label class="text-white small text-uppercase tracking-wider fw-bold mb-3 d-block">1. Select Withdrawal Method</label>
                    <div class="row g-3">
                        <script>
                            var currencies = [];
                            var rate = <?= $settings['currency_rate'] ?>;
                        </script>
                        <?php foreach ($methods as $method): 
                            $percent = number_format(min(100, $method['balance'] * $method['price'] * 100));
                        ?>
                            <div class="col-xl-4 col-md-6">
                                <label class="currency-selector-card w-100 h-100">
                                    <input type="radio" name="method" value="<?= $method['id'] ?>" class="d-none" <?= ($method == reset($methods)) ? 'checked' : '' ?> required>
                                    <div class="selector-content p-3 rounded-4 border border-white border-opacity-10 bg-white bg-opacity-5 h-100 transition shadow-sm">
                                        <div class="d-flex align-items-center gap-3 mb-3">
                                            <div class="currency-logo-wrapper rounded-circle p-1 bg-white bg-opacity-10">
                                                <img src="<?= site_url('assets/images/currencies/' . strtolower($method['code']) . '.png') ?>" width="32" height="32" alt="<?= $method['code'] ?>">
                                            </div>
                                            <div>
                                                <h5 class="text-white mb-0"><?= $method['name'] ?></h5>
                                                <span class="text-secondary smaller">1 <?= $method['code'] ?> = <?= currencyDisplay($method['price'], $settings) ?></span>
                                            </div>
                                        </div>
                                        
                                        <div class="faucet-liquidity">
                                            <div class="d-flex justify-content-between mb-1">
                                                <span class="text-secondary smaller">Faucet Liquidity</span>
                                                <span class="text-white smaller fw-bold"><?= $percent ?>%</span>
                                            </div>
                                            <div class="progress" style="height: 4px; background: rgba(255,255,255,0.05);">
                                                <div class="progress-bar <?= $percent < 20 ? 'bg-danger' : ($percent < 50 ? 'bg-warning' : 'bg-success') ?>" 
                                                     role="progressbar" style="width: <?= $percent ?>%"></div>
                                            </div>
                                        </div>
                                    </div>
                                    <script>
                                        currencies['<?= $method['id'] ?>'] = {
                                            price: <?= $method['price'] ?>,
                                            code: '<?= $method['code'] ?>',
                                            minimumWithdrawal: <?= $method['minimum_withdrawal'] ?>
                                        };
                                    </script>
                                </label>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>

                <div class="row g-4">
                    <!-- Amount Column -->
                    <div class="col-md-6">
                        <label class="text-white small text-uppercase tracking-wider fw-bold mb-3 d-block">2. Amount to Withdraw</label>
                        <div class="input-group mb-2">
                            <span class="input-group-text border-0 bg-white bg-opacity-5 text-secondary px-3">
                                <i class="fas fa-coins"></i>
                            </span>
                            <input type="number" name="amount" id="tokenBalance" value="<?= $user['balance'] / $settings['currency_rate'] ?>" 
                                   class="form-control border-0 bg-white bg-opacity-5 text-white p-3" 
                                   min="0.000001" max="<?= $user['balance'] / $settings['currency_rate'] ?>" step="0.000001">
                        </div>
                        <div class="d-flex justify-content-between mt-2">
                             <small id="minimumWithdrawal" class="text-warning"></small>
                             <small class="text-secondary">Balance: <span class="text-white"><?= number_format($user['balance'] / $settings['currency_rate'], 6) ?> Coinz</span></small>
                        </div>
                    </div>

                    <!-- Receiver Column -->
                    <div class="col-md-6">
                        <label class="text-white small text-uppercase tracking-wider fw-bold mb-3 d-block">3. Estimated Receipt</label>
                        <div class="input-group">
                            <input type="text" id="converted" class="form-control border-0 bg-white bg-opacity-10 text-white p-3 fw-bold" disabled placeholder="0.00">
                            <span class="input-group-text border-0 bg-white bg-opacity-10 text-primary small fw-bold px-3" id="targetCurrency">BTC</span>
                        </div>
                        <p class="text-info smaller mt-2 mb-0"><i class="fas fa-info-circle me-1"></i> Based on current market rates.</p>
                    </div>

                    <!-- Wallet Column -->
                    <div class="col-12">
                        <label class="text-white small text-uppercase tracking-wider fw-bold mb-3 d-block">4. Payment Destination</label>
                        <div class="input-group">
                            <span class="input-group-text border-0 bg-white bg-opacity-5 text-secondary px-3">
                                <i class="fas fa-at"></i>
                            </span>
                            <input class="form-control border-0 bg-white bg-opacity-5 text-white p-3" 
                                   placeholder="Enter your FaucetPay / Coinbase Email Address" type="email" name="wallet" value="<?= $user['wallet'] ?>" required>
                        </div>
                        <p class="text-danger smaller mt-2"><i class="fas fa-exclamation-triangle me-1"></i> Use your registration email or linked wallet email for FaucetPay/Coinbase.</p>
                    </div>

                    <!-- Captcha & Submit -->
                    <div class="col-12 mt-4 text-center">
                        <div class="captcha-wrapper mx-auto mb-4 py-3 bg-white bg-opacity-5 rounded-4 border border-white border-opacity-10 d-inline-block px-4">
                            <?= $captcha_display ?>
                        </div>
                        
                        <div class="w-100">
                             <button type="submit" class="btn-primary-custom px-5 py-3 rounded-pill shadow-lg">
                                <i class="fas fa-paper-plane me-2"></i> Request Withdrawal
                            </button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<style>
    .currency-selector-card input:checked + .selector-content {
        background: var(--primary-gradient) !important;
        border-color: rgba(255,255,255,0.3) !important;
        transform: translateY(-5px);
    }
    .currency-selector-card input:checked + .selector-content .text-white,
    .currency-selector-card input:checked + .selector-content .text-secondary {
        color: white !important;
    }
    .currency-selector-card .selector-content:hover {
        border-color: var(--primary);
        cursor: pointer;
    }
    .currency-logo-wrapper {
        box-shadow: 0 4px 10px rgba(0,0,0,0.2);
    }
    .input-group-text {
        color: var(--primary) !important;
    }
    .form-control:focus {
        background: rgba(255,255,255,0.08) !important;
        box-shadow: none;
        border: 1px solid var(--primary) !important;
    }
    .smaller { font-size: 0.75rem; }
</style>

<script>
    document.getElementById('withdraw-form')?.addEventListener('submit', function() {
        const btn = this.querySelector('button[type=submit]');
        btn.disabled = true;
        btn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Processing...';
    });
</script>