<?php if ($settings['wheel_top_ad']) { ?>
    <div class="ads mb-4 text-center">
        <?= $settings['wheel_top_ad'] ?>
    </div>
<?php } ?>

<div class="row g-4 mb-4">
    <div class="col-md-6 col-xl-3">
        <div class="dashboard-card text-center">
            <div class="feature-icon mx-auto mb-3">
                <i class="fas fa-clock text-gradient"></i>
            </div>
            <h5 class="text-secondary small text-uppercase">Claim Timer</h5>
            <h3 class="text-white mb-0">
                <?php if ($wait) { ?>
                    <span id="faucet-timer"><b id="minute"><?= floor($wait / 60) ?></b>:<b id="second"><?= sprintf('%02d', $wait % 60) ?></b></span>
                <?php } else { ?>
                    <span class="text-success">Ready</span>
                <?php } ?>
            </h3>
        </div>
    </div>
    <div class="col-md-6 col-xl-3">
        <div class="dashboard-card text-center">
            <div class="feature-icon mx-auto mb-3 text-info">
                <i class="fas fa-bolt text-info"></i>
            </div>
            <h5 class="text-secondary small text-uppercase">Energy</h5>
            <h3 class="text-white mb-0"><?= $settings['wheel_energy'] ?> <small class="text-secondary">/ spin</small></h3>
        </div>
    </div>
    <div class="col-md-6 col-xl-3">
        <div class="dashboard-card text-center">
            <div class="feature-icon mx-auto mb-3">
                <i class="fas fa-history text-gradient"></i>
            </div>
            <h5 class="text-secondary small text-uppercase">Spin Every</h5>
            <h3 class="text-white mb-0"><?= floor($settings['wheel_timer'] / 60) ?> Minutes</h3>
        </div>
    </div>
    <div class="col-md-6 col-xl-3">
        <div class="dashboard-card text-center">
            <div class="feature-icon mx-auto mb-3">
                <i class="fas fa-star text-gradient"></i>
            </div>
            <h5 class="text-secondary small text-uppercase">Claims Left</h5>
            <h3 class="text-white mb-0"><?= $settings['wheel_limit'] - $user['wheel_cnt'] ?> / <?= $settings['wheel_limit'] ?></h3>
        </div>
    </div>
</div>

<div class="row g-4 justify-content-center">
    <div class="col-lg-8">
        <div class="dashboard-card p-4 p-md-5 text-center">
            <div class="d-flex align-items-center justify-content-center gap-3 mb-5">
                <div class="feature-icon small bg-primary bg-opacity-10">
                    <i class="fas fa-bullseye text-gradient"></i>
                </div>
                <h2 class="text-white mb-0 uppercase tracking-widest">Fortune Wheel</h2>
            </div>

            <?php if (isset($_SESSION['message'])) echo '<div class="mb-4">' . $_SESSION['message'] . '</div>'; ?>

            <?php if ($limit) { ?>
                <div class="alert alert-warning border-0 bg-warning bg-opacity-10 text-warning p-4 rounded-4 mb-4">
                    <i class="fas fa-ban me-2"></i> Daily limit reached! Spin again tomorrow.
                </div>
            <?php } else if ($wait) { ?>
                <div class="py-5">
                    <div class="spinner-grow text-primary mb-3" style="width: 3rem; height: 3rem;"></div>
                    <h4 class="text-white">Reloading the wheel...</h4>
                    <p class="text-secondary small italic">Please wait for the timer to reset.</p>
                </div>
                <script type="text/javascript">var wait = <?= $wait ?> - 1;</script>
            <?php } else { ?>
                <form id="wheel-form">
                    <input type="hidden" name="<?= $csrf_name ?>" id="token" value="<?= $csrf_hash ?>">

                    <div class="wheel-container mb-5 position-relative mx-auto">
                        <div class="wheel-pointer">
                            <i class="fas fa-caret-down text-info display-4"></i>
                        </div>
                        <div class="wheel-wrap rounded-circle p-2 bg-white bg-opacity-5 border border-white border-opacity-10 shadow-lg">
                            <canvas id='canvas' width='305' height='305'>Canvas not supported.</canvas>
                        </div>
                    </div>

                    <?php if ($settings['antibotlinks'] == 'on') echo $antibot_show_info; ?>

                    <div class="atb-row mb-4">
                        <div class="d-flex flex-wrap justify-content-center gap-2">
                            <div class="antibotlinks"></div>
                            <div class="antibotlinks"></div>
                            <div class="antibotlinks"></div>
                        </div>
                    </div>

                    <div class="captcha-wrapper mb-4 p-3 bg-white bg-opacity-5 rounded-4">
                        <?= $captcha_display ?>
                    </div>

                    <div class="mt-4">
                        <?php if ($user['energy'] >= $settings['wheel_energy']): ?>
                            <button type="button" class="btn-primary-custom w-100 py-3 rounded-pill fw-bold spinning-btn" id="spin-button">
                                <i class="fas fa-sync-alt me-2"></i> SPIN & WIN (-<?= $settings['wheel_energy'] ?> Energy)
                            </button>
                        <?php else: ?>
                            <button type="button" class="btn btn-dark w-100 py-3 rounded-pill opacity-50" disabled>
                                <i class="fas fa-battery-empty me-2"></i> INSUFFICIENT ENERGY
                            </button>
                        <?php endif; ?>
                    </div>
                </form>
            <?php } ?>
        </div>
    </div>
</div>

<script>
    var prizes = [
        <?php
        for ($i = 0; $i < count($prizes); ++$i) {
            echo "{'fillStyle' : '" . $prizes[$i]['color'] . "', 'text' : '" . $prizes[$i]['text'] . "'}";
            if ($i < count($prizes) - 1) echo ",";
        }
        ?>
    ];
</script>

<style>
    .wheel-container { max-width: 325px; }
    .wheel-pointer {
        position: absolute;
        top: -25px;
        left: 50%;
        transform: translateX(-50%);
        z-index: 10;
        filter: drop-shadow(0 0 10px var(--info));
    }
    .wheel-wrap {
        background: radial-gradient(circle at center, rgba(255,255,255,0.1) 0%, rgba(255,255,255,0) 70%);
        box-shadow: 0 0 50px rgba(157, 78, 221, 0.2);
    }
    .antibotlinks img {
        max-width: 90px;
        filter: invert(1) brightness(1.5);
        border-radius: 8px;
        margin: 5px;
        cursor: pointer;
        transition: var(--transition);
    }
    .antibotlinks img:hover { transform: scale(1.1); }
</style>