<?php if ($settings['dashboard_top_ad']) { ?>
    <div class="ads mb-4 text-center">
        <?= $settings['dashboard_top_ad'] ?>
    </div>
<?php } ?>

<div class="row g-4 justify-content-center pt-4">
    <!-- Notice Bar -->
    <div class="col-lg-8">
        <div class="alert alert-warning border-0 bg-warning bg-opacity-10 text-warning p-4 rounded-4 mb-4 d-flex align-items-center gap-3">
            <div class="feature-icon small bg-warning bg-opacity-20 flex-shrink-0">
                <i class="fas fa-exclamation-triangle"></i>
            </div>
            <div>
                <p class="mb-0 fw-bold">Balance Transfer Policy</p>
                <p class="mb-0 small opacity-75">You can only transfer from <span class="text-white">Main Balance</span> to <span class="text-white">Deposit Balance</span>. This process <u>cannot</u> be reversed.</p>
            </div>
        </div>
    </div>

    <!-- Transfer Box -->
    <div class="col-lg-6">
        <div class="dashboard-card p-4 p-md-5">
            <div class="d-flex flex-column align-items-center mb-5 text-center">
                <div class="feature-icon small bg-primary bg-opacity-10 mb-3">
                    <i class="fas fa-exchange-alt text-gradient"></i>
                </div>
                <h2 class="text-white mb-1">Transfer Balance</h2>
                <p class="text-secondary small">Move your earnings to use for advertising or other site features.</p>
            </div>

            <div class="d-flex justify-content-around mb-5 p-3 rounded-4 bg-white bg-opacity-5 border border-white border-opacity-5">
                <div class="text-center">
                    <p class="text-secondary smaller text-uppercase mb-1">Main Balance</p>
                    <h5 class="text-white mb-0"><?= number_format($user['balance'] / $settings['currency_rate'], 4) ?> <small class="smaller">Coinz</small></h5>
                </div>
                <div class="divider-vertical bg-white bg-opacity-10" style="width: 1px; height: 40px;"></div>
                <div class="text-center">
                    <p class="text-secondary smaller text-uppercase mb-1">Deposit Balance</p>
                    <h5 class="text-info mb-0"><?= number_format($user['dep_balance'] / $settings['currency_rate'], 4) ?> <small class="smaller">Coinz</small></h5>
                </div>
            </div>

            <?php if (isset($_SESSION['message'])) echo '<div class="mb-4">' . $_SESSION['message'] . '</div>'; ?>

            <form action="<?= site_url('/account/transfer_balance') ?>" method="POST">
                <input type="hidden" name="<?= $csrf_name ?>" id="token" value="<?= $csrf_hash ?>">

                <div class="mb-4">
                    <label class="text-secondary small text-uppercase fw-bold mb-2 d-block text-start">Amount to Transfer</label>
                    <div class="input-group">
                        <span class="input-group-text border-0 bg-white bg-opacity-5 text-secondary px-3">
                            <i class="fas fa-coins small"></i>
                        </span>
                        <input type="number" name="amount" class="form-control border-0 bg-white bg-opacity-5 text-white p-3" 
                               placeholder="0.00" autocomplete="off" min="0.000001" max="<?= $user['balance'] / $settings['currency_rate'] ?>" step="0.000001" required>
                    </div>
                    <div class="text-end mt-2">
                        <button type="button" class="btn btn-link p-0 smaller text-primary text-decoration-none" onclick="document.getElementsByName('amount')[0].value = <?= $user['balance'] / $settings['currency_rate'] ?>;">Transfer Max</button>
                    </div>
                </div>

                <button type="submit" class="btn-primary-custom w-100 py-3 rounded-pill shadow-lg">
                    <i class="fas fa-check-double me-2"></i> Confirm Transfer
                </button>
            </form>
        </div>
    </div>
</div>

<style>
    .smaller { font-size: 0.75rem; }
    .input-group-text i { font-size: 0.9rem; }
</style>