<?php if ($settings['achievements_top_ad']) { ?>
    <div class="ads mb-4 text-center">
        <?= $settings['achievements_top_ad'] ?>
    </div>
<?php } ?>

<div class="row g-4 justify-content-center">
    <div class="col-lg-10">
        <div class="d-flex align-items-center gap-3 mb-5">
            <div class="feature-icon small bg-primary bg-opacity-10">
                <i class="fas fa-users-cog text-gradient"></i>
            </div>
            <div>
                <h2 class="text-white mb-0">Referral Milestones</h2>
                <p class="text-secondary small mb-0">Grow our community and unlock exclusive cash rewards.</p>
            </div>
        </div>

        <?php if (isset($_SESSION['message'])) echo '<div class="mb-4 text-start">' . $_SESSION['message'] . '</div>'; ?>

        <div class="row g-4 justify-content-center">
            <?php foreach ($milestones as $milestone): 
                $isClaimed = $milestone['claimed_user'];
                $isCompleted = $milestone['completed'] >= $milestone['condition'];
                $progress = min(100, $milestone['progress']);
            ?>
                <div class="col-12">
                    <div class="dashboard-card p-4 p-md-5 hover-lift transition <?= $isClaimed ? 'opacity-75' : '' ?>">
                        <div class="row align-items-center">
                            <div class="col-md-7 mb-4 mb-md-0">
                                <div class="d-flex align-items-center gap-3 mb-3">
                                    <div class="feature-icon small bg-info bg-opacity-10">
                                        <i class="fas fa-user-plus text-info"></i>
                                    </div>
                                    <h4 class="text-white mb-0">Invite <?= $milestone['condition'] ?> Active Friends</h4>
                                </div>
                                <p class="text-secondary small mb-4">Introduce <?= $milestone['condition'] ?> new users to receive a special bonus reward.</p>
                                
                                <div class="d-flex align-items-center gap-3">
                                    <div class="flex-grow-1">
                                        <div class="d-flex justify-content-between mb-2 small fw-bold">
                                            <span class="<?= $isCompleted ? 'text-success' : 'text-secondary' ?>">
                                                <?= $isCompleted ? '<i class="fas fa-check-circle me-1"></i> Completed' : 'In Progress' ?>
                                            </span>
                                            <span class="text-white"><?= $milestone['completed'] ?> / <?= $milestone['condition'] ?></span>
                                        </div>
                                        <div class="progress rounded-pill bg-white bg-opacity-5" style="height: 10px;">
                                            <div class="progress-bar progress-bar-striped progress-bar-animated <?= $isCompleted ? 'bg-success' : 'bg-primary' ?>" 
                                                 role="progressbar" style="width: <?= $progress ?>%"></div>
                                        </div>
                                    </div>
                                    <div class="reward-badge p-3 rounded-4 bg-warning bg-opacity-10 border border-warning border-opacity-10 text-center min-w-100">
                                        <p class="text-secondary smaller text-uppercase mb-1 tracking-wider">Reward</p>
                                        <h5 class="text-warning mb-0 fw-bold"><?= currencyDisplay($milestone['reward_usd'], $settings) ?></h5>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-5 text-md-end">
                                <?php if ($isClaimed): ?>
                                    <button disabled class="btn btn-dark rounded-pill px-5 py-3 opacity-50 border-0">
                                        <i class="fas fa-check-double me-2"></i> REWARD CLAIMED
                                    </button>
                                <?php elseif ($isCompleted): ?>
                                    <form action="<?= site_url('referral_milestones/claim/' . $milestone['id']) ?>" method="POST">
                                        <input type="hidden" name="<?= $csrf_name ?>" value="<?= $csrf_hash ?>">
                                        <button type="submit" class="btn-primary-custom px-5 py-3 rounded-pill shadow-lg bg-success border-0" style="background: linear-gradient(135deg, #198754, #20c997) !important;">
                                            <i class="fas fa-gift me-2"></i> CLAIM NOW
                                        </button>
                                    </form>
                                <?php else: ?>
                                    <button disabled class="btn btn-dark rounded-pill px-5 py-3 opacity-25 border-white border-opacity-10">
                                        <i class="fas fa-hourglass-half me-2"></i> KEEP REFERRING
                                    </button>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>

<style>
    .smaller { font-size: 0.7rem; }
    .min-w-100 { min-width: 120px; }
</style>