<?php if ($settings['ptc_top_ad']) { ?>
    <div class="ads mb-4 text-center">
        <?= $settings['ptc_top_ad'] ?>
    </div>
<?php } ?>

<div class="row g-4 mb-4">
    <!-- Total Ads Available -->
    <div class="col-md-6">
        <div class="dashboard-card text-center hover-lift">
            <div class="feature-icon mx-auto mb-3">
                <i class="fas fa-mouse-pointer text-gradient"></i>
            </div>
            <h5 class="text-secondary small text-uppercase">Ads Available</h5>
            <h3 class="text-white mb-0"><?= $totalAds ?></h3>
        </div>
    </div>

    <!-- Total Reward Potential -->
    <div class="col-md-6">
        <div class="dashboard-card text-center hover-lift">
            <div class="feature-icon mx-auto mb-3">
                <i class="fas fa-coins text-gradient"></i>
            </div>
            <h5 class="text-secondary small text-uppercase">Total Potential Earning</h5>
            <h3 class="text-white mb-0"><?= currencyDisplay($totalReward, $settings) ?></h3>
        </div>
    </div>
</div>

<div class="row g-4">
    <script id="aclib" type="text/javascript" src="//acscdn.com/script/aclib.js"></script>

    <?php 
    $total = count($ptcAds);
    $insert_pos = (int) floor($total / 2);
    $i = 0;
    ?>

    <?php foreach ($ptcAds as $ads): ?>
        
        <!-- Sponsored Ad Logic -->
        <?php if ($i == $insert_pos): ?>
            <div class="col-lg-6 col-xl-4">
                <div class="dashboard-card h-100 d-flex flex-column justify-content-between p-4" style="background: linear-gradient(135deg, rgba(240, 5, 193, 0.05), rgba(157, 78, 221, 0.05)); border-color: var(--primary-light) !important;">
                    <div>
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <span class="badge bg-primary text-white px-2 py-1 small">SPONSORED</span>
                            <i class="fas fa-star text-warning"></i>
                        </div>
                        <h4 class="text-white mb-2">High Reward Ad</h4>
                        <p class="text-secondary small mb-4">Support the platform and earn extra rewards by visiting this sponsored link.</p>
                        
                        <div class="ptc-external-ad mb-4 text-center">
                            <ins class="6917766b57295e26a9b98c1a" style="display:inline-block;width:1px;height:1px;"></ins>
                            <script>!function(e,n,c,t,o,r,d){!function e(n,c,t,o,r,m,d,s,a){s=c.getElementsByTagName(t)[0],(a=c.createElement(t)).async=!0,a.src="https://"+r[m]+"/js/"+o+".js?v="+d,a.onerror=function(){a.remove(),(m+=1)>=r.length||e(n,c,t,o,r,m)},s.parentNode.insertBefore(a,s)}(window,document,"script","6917766b57295e26a9b98c1a",["cdn.bmcdn6.com"], 0, new Date().getTime())}();</script>
                        </div>
                    </div>
                    <button class="btn-primary-custom w-100" disabled>Click Above to Visit</button>
                </div>
            </div>
        <?php endif; ?>

        <!-- Actual PTC Ads -->
        <div class="col-lg-6 col-xl-4">
            <div class="dashboard-card h-100 d-flex flex-column justify-content-between p-4">
                <div>
                    <h4 class="text-white mb-2"><?= $ads['name'] ?></h4>
                    <p class="text-secondary small mb-4"><?= $ads['description'] ?></p>
                    
                    <div class="d-flex gap-3 mb-4">
                        <div class="d-flex align-items-center gap-2 px-3 py-2 rounded-pill bg-white bg-opacity-5 border border-white border-opacity-5">
                            <i class="fas fa-coins text-warning small"></i>
                            <span class="text-white fw-bold small"><?= currencyDisplay($ads['reward'], $settings) ?></span>
                        </div>
                        <div class="d-flex align-items-center gap-2 px-3 py-2 rounded-pill bg-white bg-opacity-5 border border-white border-opacity-5">
                            <i class="fas fa-clock text-info small"></i>
                            <span class="text-white fw-bold small"><?= $ads['timer'] ?>s</span>
                        </div>
                    </div>
                </div>
                
                <button onclick="window.location = '<?= site_url('ptc/view/' . $ads['id']) ?>'" class="btn-primary-custom w-100">
                    <i class="fas fa-external-link-alt me-2"></i> Visit Website
                </button>
            </div>
        </div>

        <?php $i++; ?>
    <?php endforeach; ?>

    <?php if ($total == 0): ?>
        <div class="col-12 mt-5 text-center">
            <div class="dashboard-card py-5">
                <i class="fas fa-ghost fa-4x text-muted mb-4"></i>
                <h3 class="text-white">All Ads Viewed!</h3>
                <p class="text-secondary">You've visited all available advertisements for now. Check back later for more earning opportunities.</p>
                <a href="<?= site_url('dashboard') ?>" class="btn-primary-custom px-5 mt-3">Back to Dashboard</a>
            </div>
        </div>
    <?php endif; ?>
</div>

<?php if ($settings['ptc_footer_ad']) { ?>
    <div class="ads mt-5 text-center">
        <?= $settings['ptc_footer_ad'] ?>
    </div>
<?php } ?>
