<?php if ($happyhour_status == 'on') : ?>
    <div class="row g-4 mb-4">
        <div class="col-12">
            <div class="alert alert-success border-0 bg-success bg-opacity-10 text-success p-4 rounded-4 d-flex align-items-center justify-content-center gap-3 shadow-sm">
                <div class="feature-icon small bg-success bg-opacity-20">
                    <i class="fas fa-bolt text-success"></i>
                </div>
                <div class="text-center">
                    <p class="mb-0 fw-bold h5">🎉 Happy Hour is Active! <span class="text-white">+50% Bonus</span></p>
                    <p class="mb-0 small opacity-75">Bonus ends in <span id="countdown" class="text-white fw-bold">00:00:00</span></p>
                </div>
            </div>
        </div>
    </div>
    <script>
        function startCountdown(endTime) {
            let countdownElement = document.getElementById("countdown");
            function updateCountdown() {
                let now = Math.floor(Date.now() / 1000);
                let distance = endTime - now;
                if (distance <= 0) { countdownElement.innerHTML = "00:00:00"; return; }
                let hours = Math.floor(distance / 3600);
                let minutes = Math.floor((distance % 3600) / 60);
                let seconds = distance % 60;
                countdownElement.innerHTML = (hours < 10 ? "0" + hours : hours) + ":" + (minutes < 10 ? "0" + minutes : minutes) + ":" + (seconds < 10 ? "0" + seconds : seconds);
                setTimeout(updateCountdown, 1000);
            }
            updateCountdown();
        }
        let happyHourEndTime = localStorage.getItem("happyHourEndTime");
        if ('<?= $happyhour_status; ?>' === 'on') {
            if (!happyHourEndTime || Date.now() / 1000 > happyHourEndTime) {
                happyHourEndTime = Date.now() / 1000 + 3600;
                localStorage.setItem("happyHourEndTime", happyHourEndTime);
            }
            startCountdown(parseInt(happyHourEndTime));
        }
    </script>
<?php endif; ?>

<div class="row text-start mb-4">
    <div class="col-12">
        <h2 class="text-white mb-1">Available Offerwalls</h2>
        <p class="text-secondary small">Complete high-paying surveys, offers, and tasks from our trusted partners.</p>
    </div>
</div>

<div class="row g-4">
    <?php
    $offerwalls = [
        ['status' => $settings['gemiad_status'], 'id' => 'gemiad', 'name' => 'GemiAd', 'tags' => ['PTC', 'Links', 'Games'], 'bonus' => '50%'],
        ['status' => $settings['notik_status'], 'id' => 'notik', 'name' => 'Notik', 'tags' => ['Offers', 'Survey', 'PTC']],
        ['status' => 'on', 'id' => 'timewall', 'name' => 'TimeWall', 'tags' => ['PTC', 'Survey', 'Tasks']],
        ['status' => $settings['adgem_status'], 'id' => 'adgem', 'name' => 'AdGem', 'tags' => ['Offers', 'Games']],
        ['status' => $settings['earnetize_status'], 'id' => 'earnetize', 'name' => 'Earnetize', 'tags' => ['Offers', 'Survey']],
        ['status' => $settings['edotiva_status'], 'id' => 'edotiva', 'name' => 'Edotiva', 'tags' => ['Offers', 'Survey']],
        ['status' => $settings['adswedmedia_status'], 'id' => 'adswedmedia', 'name' => 'Adswedmedia', 'tags' => ['Offers', 'Games']],
        ['status' => $settings['adrevmedia_status'], 'id' => 'adrevmedia', 'name' => 'AdRevMedia', 'tags' => ['Offers', 'Survey']],
        ['status' => $settings['adfleetmedia_status'], 'id' => 'adfleetmedia', 'name' => 'AdFleetMedia', 'tags' => ['Offers', 'Tasks']],
        ['status' => $settings['taskwall_status'], 'id' => 'taskwall', 'name' => 'TaskWall', 'tags' => ['Offers', 'Tasks']],
        ['status' => $settings['upwall_status'], 'id' => 'upwall', 'name' => 'UPWall', 'tags' => ['Offers', 'Survey']],
        ['status' => $settings['monlix_status'], 'id' => 'monlix', 'name' => 'Monlix', 'tags' => ['PTC', 'Survey', 'Games'], 'bonus' => 'Extra'],
        ['status' => 'on', 'id' => 'offers4crypto', 'name' => 'Offerwall.me', 'tags' => ['PTC', 'Survey'], 'img' => 'offerwall.png'],
        ['status' => 'on', 'id' => 'bitcotasks', 'name' => 'BitcoTasks', 'tags' => ['PTC', 'Faucet', 'Survey']],
        ['status' => $settings['offery_status'] ?? 'off', 'id' => 'offery', 'name' => 'Offery', 'tags' => ['Offers', 'Games']]
    ];

    foreach ($offerwalls as $ow): 
        if (($ow['status'] ?? 'off') !== 'on') continue;
        $img = $ow['img'] ?? ($ow['id'] . '.' . (($ow['id'] == 'timewall' || $ow['id'] == 'upwall' || $ow['id'] == 'monlix') ? 'webp' : ($ow['id'] == 'earnetize' ? 'webp' : (($ow['id'] == 'gemiad' || $ow['id'] == 'notik' || $ow['id'] == 'edotiva' || $ow['id'] == 'adrevmedia' || $ow['id'] == 'monlix') ? 'svg' : 'png')))));
    ?>
        <div class="col-md-6 col-xl-4">
            <div class="dashboard-card h-100 p-4 d-flex flex-column justify-content-between position-relative overflow-hidden hover-lift transition">
                <?php if (isset($ow['bonus'])): ?>
                    <div class="offer-bonus-badge"><?= $ow['bonus'] ?> BONUS</div>
                <?php endif; ?>

                <div class="text-center">
                    <div class="offerwall-logo-container mb-4 mx-auto p-3 bg-white bg-opacity-5 rounded-4 d-flex align-items-center justify-content-center" style="height: 100px;">
                        <img src="<?= base_url() ?>assets/coinzi/dash/img/<?= $img ?>" class="img-fluid" style="max-height: 50px;" alt="<?= $ow['name'] ?>">
                    </div>
                    
                    <h5 class="text-white mb-2"><?= $ow['name'] ?></h5>
                    
                    <div class="d-flex flex-wrap justify-content-center gap-2 mb-4">
                        <?php foreach ($ow['tags'] as $tag): ?>
                            <span class="badge rounded-pill bg-primary bg-opacity-10 text-primary small px-2 py-1"><?= $tag ?></span>
                        <?php endforeach; ?>
                    </div>

                    <div class="star-rating mb-4 text-warning opacity-75 small">
                        <?php for($i=0; $i<5; $i++): ?><i class="fas fa-star me-1"></i><?php endfor; ?>
                    </div>
                </div>

                <a href="<?= site_url('offerwall/' . $ow['id']) ?>" class="btn-primary-custom w-100 py-2">
                    Open <?= $ow['name'] ?>
                </a>
            </div>
        </div>
    <?php endforeach; ?>
    
    <!-- Bitmedia Ad Inclusion inside a matching card -->
    <div class="col-md-6 col-xl-4">
        <div class="dashboard-card h-100 d-flex align-items-center justify-content-center p-3">
            <div class="text-center opacity-75">
                <p class="text-secondary smaller mb-2">SPONSORED</p>
                <ins class="6917766b57295e26a9b98c1a" style="display:inline-block;width:1px;height:1px;"></ins>
                <script>!function(e,n,c,t,o,r,d){!function e(n,c,t,o,r,m,d,s,a){s=c.getElementsByTagName(t)[0],(a=c.createElement(t)).async=!0,a.src="https://"+r[m]+"/js/"+o+".js?v="+d,a.onerror=function(){a.remove(),(m+=1)>=r.length||e(n,c,t,o,r,m)},s.parentNode.insertBefore(a,s)}(window,document,"script","6917766b57295e26a9b98c1a",["cdn.bmcdn6.com"], 0, new Date().getTime())}();</script>
            </div>
        </div>
    </div>
</div>

<style>
    .offerwall-logo-container img {
        transition: var(--transition);
        filter: brightness(1.1);
    }
    .hover-lift:hover .offerwall-logo-container img {
        transform: scale(1.1);
    }
    .offer-bonus-badge {
        position: absolute;
        top: 15px;
        right: -30px;
        background: linear-gradient(135deg, #f05, #ff007b);
        color: white;
        padding: 5px 35px;
        font-size: 0.65rem;
        font-weight: 800;
        transform: rotate(45deg);
        box-shadow: 0 4px 10px rgba(255, 0, 85, 0.4);
        z-index: 1;
        letter-spacing: 1px;
    }
    .smaller { font-size: 0.7rem; }
</style>