<div class="row g-4 justify-content-center">
    <!-- Mining Info Card -->
    <div class="col-lg-12">
        <div class="dashboard-card p-4 p-md-5">
            <div class="d-flex align-items-center justify-content-between flex-wrap gap-4 mb-5">
                <div class="d-flex align-items-center gap-3">
                    <div class="feature-icon small bg-primary bg-opacity-10">
                        <i class="fas fa-microchip text-gradient pulse"></i>
                    </div>
                    <div>
                        <h2 class="text-white mb-0 capitalize tracking-widest">Browser Mining</h2>
                        <p class="text-secondary small mb-0">Use your CPU power to earn additional rewards while you browse.</p>
                    </div>
                </div>

                <div class="mining-status-pill py-3 px-4 rounded-4 bg-white bg-opacity-5 border border-white border-opacity-10 text-center">
                    <p class="text-secondary smaller text-uppercase mb-1 fw-bold tracking-wider">Unclaimed Mining Balance</p>
                    <h3 class="text-white mb-2 fw-bold"><?= currencyDisplay($balance, $settings) ?></h3>
                    
                    <form action="<?= site_url('mining/withdraw') ?>" method="post">
                        <input type="hidden" name="<?= $csrf_name ?>" id="token" value="<?= $csrf_hash ?>">
                        <?php if ($balance < $min_withdrawal): ?>
                            <button type="button" disabled class="btn btn-dark btn-sm rounded-pill px-3 opacity-50">
                                <i class="fas fa-lock small me-1"></i> Min Withdrawal: <?= currencyDisplay($min_withdrawal, $settings) ?>
                            </button>
                        <?php else: ?>
                            <button type="submit" class="btn btn-success btn-sm rounded-pill px-4 shadow-sm">
                                <i class="fas fa-cloud-download-alt me-1"></i> Withdraw to Balance
                            </button>
                        <?php endif; ?>
                    </form>
                </div>
            </div>

            <?php if (isset($_SESSION['message'])) echo '<div class="mb-4 text-start">' . $_SESSION['message'] . '</div>'; ?>

            <!-- Mining Interface Container -->
            <div class="mining-interface-wrapper p-4 p-md-5 rounded-4 border border-white border-opacity-5 bg-black bg-opacity-20 shadow-lg position-relative overflow-hidden">
                <div class="mining-glow position-absolute top-0 start-50 translate-middle-x" style="width: 200px; height: 10px; background: var(--primary); filter: blur(40px); opacity: 0.3;"></div>
                
                <div class="text-start mb-4">
                    <h5 class="text-white small text-uppercase tracking-widest mb-3 opacity-75"><i class="fas fa-terminal me-2"></i> Miner Console</h5>
                </div>

                <!-- WebMinePool Widget -->
                <script src="https://webminepool.com/lib/simple-ui.js"></script>
                <div id="wmp-container" 
                     wmp-site-key="<?= $settings['webminepool_site_key'] ?>" 
                     wmp-username="<?= $user['username'] ?>" 
                     wmp-threads="2" 
                     wmp-throttle="0.1" 
                     wmp-autostart="false" 
                     class="mx-auto">
                </div>
                
                <div class="mt-4 p-3 bg-white bg-opacity-5 rounded-3 border border-white border-opacity-5 text-start">
                    <p class="text-info smaller mb-0"><i class="fas fa-info-circle me-1"></i> Browser mining is safe and doesn't harm your hardware. You can adjust CPU threads and speed anytime.</p>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .smaller { font-size: 0.75rem; }
    .pulse { animation: miner-pulse 2s infinite ease-in-out; }
    @keyframes miner-pulse {
        0% { opacity: 1; transform: scale(1); }
        50% { opacity: 0.7; transform: scale(1.1); filter: drop-shadow(0 0 10px var(--primary)); }
        100% { opacity: 1; transform: scale(1); }
    }
    .mining-interface-wrapper { border-top: 1px solid rgba(157, 78, 221, 0.2) !important; }
    #wmp-container {
        max-width: 100% !important;
        border-radius: 12px;
        overflow: hidden;
    }
    /* Simple override for webminepool styles if they inject anything we want to hide or adjust */
    [id^="wmp-"] { color: #fff !important; }
</style>