<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8" />
    <title>Under Maintenance | <?= $settings['name'] ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="<?= $settings['description'] ?>" name="description" />
    <link rel="shortcut icon" href="<?= base_url() ?>assets/images/favicon.ico">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;600;700&display=swap" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        :root {
            --primary: #9d4edd;
            --primary-rgb: 157, 78, 221;
            --bg-body: #0a0a0f;
            --glass-bg: rgba(255, 255, 255, 0.05);
            --glass-border: rgba(255, 255, 255, 0.1);
        }

        body {
            background: radial-gradient(circle at 50% 50%, #1a1a2e 0%, #0a0a0f 100%);
            color: #ffffff;
            font-family: 'Outfit', sans-serif;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0;
            overflow: hidden;
        }

        .maintenance-card {
            background: var(--glass-bg);
            backdrop-filter: blur(20px);
            border: 1px solid var(--glass-border);
            border-radius: 2rem;
            padding: 4rem 2rem;
            max-width: 600px;
            width: 90%;
            text-align: center;
            box-shadow: 0 25px 50px rgba(0, 0, 0, 0.3);
            position: relative;
            z-index: 10;
        }

        .feature-icon-large {
            width: 120px;
            height: 120px;
            background: linear-gradient(135deg, rgba(var(--primary-rgb), 0.2), rgba(var(--primary-rgb), 0.05));
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 2rem;
            border: 1px solid rgba(var(--primary-rgb), 0.3);
            box-shadow: 0 0 30px rgba(var(--primary-rgb), 0.2);
            animation: pulse 2s infinite;
        }

        .text-gradient {
            background: linear-gradient(to right, #ffffff, var(--primary));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        @keyframes pulse {
            0% { transform: scale(1); box-shadow: 0 0 0px rgba(var(--primary-rgb), 0); }
            50% { transform: scale(1.05); box-shadow: 0 0 40px rgba(var(--primary-rgb), 0.4); }
            100% { transform: scale(1); box-shadow: 0 0 0px rgba(var(--primary-rgb), 0); }
        }

        .social-links a {
            color: rgba(255, 255, 255, 0.5);
            font-size: 1.5rem;
            margin: 0 1rem;
            transition: all 0.3s ease;
        }
        .social-links a:hover {
            color: var(--primary);
            transform: translateY(-3px);
        }

        .bg-blobs {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            overflow: hidden;
            z-index: 1;
        }
        .blob {
            position: absolute;
            width: 400px;
            height: 400px;
            background: rgba(var(--primary-rgb), 0.1);
            filter: blur(80px);
            border-radius: 50%;
        }
    </style>
</head>
<body>
    <div class="bg-blobs">
        <div class="blob" style="top: -100px; left: -100px;"></div>
        <div class="blob" style="bottom: -100px; right: -100px; background: rgba(58, 134, 255, 0.1);"></div>
    </div>

    <div class="maintenance-card">
        <div class="feature-icon-large">
            <i class="fas fa-tools text-primary" style="font-size: 3.5rem;"></i>
        </div>
        
        <h1 class="display-5 fw-bold mb-3 text-gradient">Under Maintenance</h1>
        <p class="text-secondary mb-5 lead">We're currently fine-tuning <?= $settings['name'] ?> to bring you a better experience. We'll be back online shortly!</p>
        
        <div class="d-flex flex-column align-items-center gap-4">
            <div class="social-links">
                <a href="#"><i class="fab fa-telegram-plane"></i></a>
                <a href="#"><i class="fab fa-twitter"></i></a>
                <a href="#"><i class="fab fa-discord"></i></a>
            </div>
            
            <div class="mt-2">
                <a href="<?= site_url() ?>" class="btn btn-outline-light rounded-pill px-4 py-2 small opacity-50 text-decoration-none">
                    <i class="fas fa-redo me-2"></i> Refresh Page
                </a>
            </div>
        </div>
    </div>

    <?= $settings['footer_code'] ?>
</body>
</html>