<?php if ($settings['mad_top_ad']) { ?>
    <div class="ads mb-4 text-center">
        <?= $settings['mad_top_ad'] ?>
    </div>
<?php } ?>

<div class="row g-4 mb-4">
    <!-- Timer Card -->
    <div class="col-md-6 col-xl-3">
        <div class="dashboard-card text-center hover-lift">
            <div class="feature-icon mx-auto mb-3">
                <i class="fas fa-bolt text-gradient"></i>
            </div>
            <h5 class="text-secondary small text-uppercase">Claim Timer</h5>
            <h3 class="text-white mb-0">
                <?php if ($wait) { ?>
                    <span id="faucet-timer">
                        <b id="minute"><?= floor($wait / 60) ?></b>:<b id="second"><?= sprintf('%02d', $wait % 60) ?></b>
                    </span>
                <?php } else { ?>
                    <span class="text-success">Ready</span>
                <?php } ?>
            </h3>
        </div>
    </div>

    <!-- Interval Card -->
    <div class="col-md-6 col-xl-3">
        <div class="dashboard-card text-center hover-lift">
            <div class="feature-icon mx-auto mb-3 text-danger">
                <i class="fas fa-fire-alt text-gradient"></i>
            </div>
            <h5 class="text-secondary small text-uppercase">Claim Every</h5>
            <h3 class="text-white mb-0"><?= $settings['mad_timer'] ?> Seconds</h3>
        </div>
    </div>

    <!-- Reward Card -->
    <div class="col-md-6 col-xl-3">
        <div class="dashboard-card text-center hover-lift">
            <div class="feature-icon mx-auto mb-3">
                <i class="fas fa-coins text-gradient"></i>
            </div>
            <h5 class="text-secondary small text-uppercase">Reward</h5>
            <h3 class="text-white mb-0"><?= currencyDisplay($settings['mad_reward'], $settings) ?></h3>
            <span class="badge bg-primary bg-opacity-10 text-primary small">+<?= $bonus ?>% Bonus</span>
        </div>
    </div>

    <!-- Daily Limit Card -->
    <div class="col-md-6 col-xl-3">
        <div class="dashboard-card text-center hover-lift">
            <div class="feature-icon mx-auto mb-3">
                <i class="fas fa-check-double text-gradient"></i>
            </div>
            <h5 class="text-secondary small text-uppercase">Claims left</h5>
            <h3 class="text-white mb-0"><?= $countHistory ?> / <?= $settings['mad_max'] ?></h3>
        </div>
    </div>
</div>

<div class="row g-4">
    <!-- Main Claim Section -->
    <div class="col-lg-8 mx-auto">
        <div class="dashboard-card p-4 p-md-5 text-center" style="background: linear-gradient(135deg, rgba(255, 0, 85, 0.05), rgba(255, 107, 107, 0.05)); border-color: rgba(255, 0, 85, 0.2) !important;">
            <div class="mb-4 d-flex align-items-center justify-content-center gap-3">
                <div class="feature-icon small bg-danger bg-opacity-10">
                    <i class="fas fa-skull text-danger"></i>
                </div>
                <h2 class="text-white mb-0 tracking-widest">MAD FAUCET</h2>
                <div class="feature-icon small bg-danger bg-opacity-10">
                    <i class="fas fa-skull text-danger"></i>
                </div>
            </div>

            <?php if ($settings['mad_header_ad']) { ?>
                <div class="ads mb-4"><?= $settings['mad_header_ad'] ?></div>
            <?php } ?>

            <?php if ($limit) { ?>
                <div class="alert alert-warning border-0 bg-warning bg-opacity-10 text-warning p-4 rounded-4 mb-4">
                    <i class="fas fa-moon me-2"></i> Daily limit reached! Come back tomorrow for more madness.
                </div>
            <?php } else if ($wait) { ?>
                <div class="py-5 text-center">
                    <div class="spinner-grow text-danger mb-3" role="status" style="width: 3rem; height: 3rem;">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                    <h4 class="text-white">Cooling down...</h4>
                    <p class="text-secondary italic">The madness returns in a few seconds.</p>
                </div>
                <script type="text/javascript">
                    var wait = <?= $wait ?> - 1;
                </script>
            <?php } else { ?>
                <form action="<?= site_url('/madfaucet/verify') ?>" method="POST" id="madfaucet-form">
                    <input type="hidden" name="<?= $csrf_name ?>" id="token" value="<?= $csrf_hash ?>">
                    
                    <div class="claim-area d-flex flex-column align-items-center gap-4">
                        <!-- Anti-Bot Links -->
                        <?php if ($settings['antibotlinks'] == 'on') { ?>
                            <div class="antibot-container p-3 rounded-4 border border-white border-opacity-5 bg-white bg-opacity-5 w-100">
                                <p class="text-secondary small mb-3">Click the Anti-Bot links in the correct order:</p>
                                <div class="atb-wrapper d-flex justify-content-center flex-wrap gap-2 mb-2">
                                    <?php for($i=0; $i<=5; $i++): ?>
                                        <?php if (in_array($i, $anti_pos)) { echo '<div class="antibotlinks"></div>'; } ?>
                                        <?php if ($i == 2) echo $antibot_show_info; ?>
                                    <?php endfor; ?>
                                </div>
                            </div>
                        <?php } ?>

                        <!-- Captcha -->
                        <div class="captcha-box p-3 rounded-4 border border-white border-opacity-5 bg-white bg-opacity-5">
                            <?= $captcha_display ?>
                        </div>

                        <!-- Submit -->
                        <div class="w-100">
                            <button type="submit" class="btn-primary-custom w-100 py-3 claim-button" style="background: linear-gradient(to right, #f05, #ff4d4d) !important;" disabled>
                                <i class="fas fa-radiation fa-spin me-2"></i> CLAIM REWARD NOW
                            </button>
                        </div>
                    </div>
                </form>
            <?php } ?>

            <?php if ($settings['mad_footer_ad']) { ?>
                <div class="ads mt-4"><?= $settings['mad_footer_ad'] ?></div>
            <?php } ?>
        </div>
    </div>
</div>

<style>
    .antibot-container .antibotlinks { display: inline-block; margin: 5px; }
    .antibot-container img {
        max-width: 100px;
        filter: invert(1) brightness(2);
        border-radius: 8px;
        transition: var(--transition);
    }
    .captcha-box { min-height: 80px; display: flex; align-items: center; justify-content: center; }
</style>

<script>
    document.getElementById('madfaucet-form')?.addEventListener('submit', function() {
        const btn = this.querySelector('.claim-button');
        btn.disabled = true;
        btn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Processing...';
    });
</script>