<?php if ($settings['lottery_top_ad']) { ?>
    <div class="ads mb-4 text-center">
        <?= $settings['lottery_top_ad'] ?>
    </div>
<?php } ?>

<div class="row g-4">
    <!-- Countdown Card -->
    <div class="col-md-6">
        <div class="dashboard-card p-4 hover-lift">
            <div class="d-flex align-items-center gap-3">
                <div class="feature-icon small bg-primary bg-opacity-10">
                    <i class="fas fa-hourglass-start text-gradient"></i>
                </div>
                <div>
                    <h5 class="text-secondary small text-uppercase mb-1 tracking-wider">Next Draw In</h5>
                    <h3 class="text-white mb-0 fw-bold"><?= timespan(time(), $settings['lottery_date'], 2) ?></h3>
                </div>
            </div>
        </div>
    </div>

    <!-- Reward Card -->
    <div class="col-md-6">
        <div class="dashboard-card p-4 hover-lift">
            <div class="d-flex align-items-center gap-3">
                <div class="feature-icon small bg-warning bg-opacity-10">
                    <i class="fas fa-trophy text-warning"></i>
                </div>
                <div>
                    <h5 class="text-secondary small text-uppercase mb-1 tracking-wider">Current Jackpot</h5>
                    <h3 class="text-white mb-0 fw-bold text-gradient"><?= currencyDisplay($current_reward, $settings) ?></h3>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row g-4 mt-2">
    <!-- Buy Tickets Section -->
    <div class="col-lg-12">
        <div class="dashboard-card p-4 p-md-5 text-center">
            <?php if (time() >= $settings['lottery_date']): ?>
                <div class="alert alert-info border-0 bg-info bg-opacity-10 text-info p-4 rounded-4 mb-0">
                    <i class="fas fa-info-circle me-2"></i> This round has ended. Calculations are in progress!
                </div>
            <?php else: ?>
                <div class="d-flex flex-column align-items-center mb-5">
                    <div class="feature-icon small bg-success bg-opacity-10 mb-3">
                        <i class="fas fa-ticket-alt text-success"></i>
                    </div>
                    <h2 class="text-white mb-1">Get Your Lucky Tickets</h2>
                    <p class="text-secondary small">Each ticket increases your chance to win the weekly jackpot.</p>
                </div>

                <?php if (isset($_SESSION['message'])) echo '<div class="mb-4 text-start">' . $_SESSION['message'] . '</div>'; ?>

                <form action="<?= site_url('/lottery/buy') ?>" method="POST" autocomplete="off" class="mx-auto" style="max-width: 500px;">
                    <input type="hidden" name="<?= $csrf_name ?>" id="token" value="<?= $csrf_hash ?>">
                    
                    <div class="mb-4">
                        <label class="text-secondary smaller fw-bold mb-2 d-block text-start">Amount of Tickets</label>
                        <div class="input-group">
                            <span class="input-group-text border-0 bg-white bg-opacity-5 text-secondary px-3"><i class="fas fa-list-ol small"></i></span>
                            <input type="number" class="form-control border-0 bg-white bg-opacity-5 text-white p-3 font-monospace fw-bold" 
                                   id="lotteryAmount" name="amount" min="1" value="1" required>
                        </div>
                    </div>

                    <button type="submit" class="btn-primary-custom w-100 py-3 rounded-pill shadow-lg" id="buyButton">
                        <i class="fas fa-shopping-cart me-2"></i> Buy Tickets with <?= currencyDisplay($settings['lottery_price'], $settings) ?>
                    </button>
                    
                    <p class="text-secondary smaller mt-3 italic"><i class="fas fa-info-circle me-1"></i> Tickets are valid for the next draw only.</p>
                </form>

                <script>
                    var lotteryPrice = <?= $settings['lottery_price'] / $settings['currency_rate'] ?>;
                    document.getElementById('lotteryAmount').addEventListener('input', function() {
                        const amount = this.value || 0;
                        const total = (amount * lotteryPrice).toFixed(4);
                        document.getElementById('buyButton').innerHTML = '<i class="fas fa-shopping-cart me-2"></i> Buy ' + amount + ' Tickets with ' + total + ' Coinz';
                    });
                </script>
            <?php endif; ?>
        </div>
    </div>

    <!-- Stats Tables -->
    <div class="col-lg-6">
        <div class="dashboard-card p-4">
            <h5 class="text-white mb-4"><i class="fas fa-history text-primary me-2"></i> Your Recent Tickets</h5>
            <div class="table-responsive">
                <table class="table table-dark table-hover border-white border-opacity-5 text-center">
                    <thead class="bg-white bg-opacity-5">
                        <tr class="text-secondary small text-uppercase">
                            <th class="border-0">#ID</th>
                            <th class="border-0">Number</th>
                            <th class="border-0 text-end">Purchased</th>
                        </tr>
                    </thead>
                    <tbody class="text-white border-0">
                        <?php if (empty($lotteries)): ?>
                            <tr><td colspan="3" class="text-center py-4 text-secondary italic border-0">No tickets found.</td></tr>
                        <?php else: ?>
                            <?php foreach ($lotteries as $value): ?>
                                <tr class="transition">
                                    <td class="border-0 py-3 font-monospace small">#<?= $value["id"] ?></td>
                                    <td class="border-0 py-3 text-center">
                                        <span class="badge rounded-pill bg-primary bg-opacity-10 text-primary px-3 py-2 border border-primary border-opacity-10"><?= $value["number"] ?></span>
                                    </td>
                                    <td class="border-0 py-3 text-end text-secondary small"><?= timespan($value["create_time"], time(), 1) ?> ago</td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <div class="col-lg-6">
        <div class="dashboard-card p-4">
            <h5 class="text-white mb-4"><i class="fas fa-crown text-warning me-2"></i> Last 10 Winners</h5>
            <div class="table-responsive">
                <table class="table table-dark table-hover border-white border-opacity-5 text-center">
                    <thead class="bg-white bg-opacity-5">
                        <tr class="text-secondary small text-uppercase">
                            <th class="border-0 text-start">Winner</th>
                            <th class="border-0">No.</th>
                            <th class="border-0">Jackpot</th>
                            <th class="border-0 text-end">Date</th>
                        </tr>
                    </thead>
                    <tbody class="text-white border-0">
                        <?php if (empty($winners)): ?>
                            <tr><td colspan="4" class="text-center py-4 text-secondary italic border-0">No winners recorded yet.</td></tr>
                        <?php else: ?>
                            <?php foreach ($winners as $value): ?>
                                <tr class="transition">
                                    <td class="border-0 py-3 text-start fw-bold"><?= $value["username"] ?></td>
                                    <td class="border-0 py-3 text-center">
                                        <span class="badge rounded-pill bg-success bg-opacity-10 text-success px-3 py-2 border border-success border-opacity-10"><?= $value["number"] ?></span>
                                    </td>
                                    <td class="border-0 py-3 fw-bold text-gradient"><?= currencyDisplay($value["amount"], $settings) ?></td>
                                    <td class="border-0 py-3 text-end text-secondary small"><?= timespan($value["create_time"], time(), 1) ?> ago</td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<style>
    .font-monospace { font-family: 'JetBrains Mono', 'Courier New', monospace !important; }
    .smaller { font-size: 0.75rem; }
</style>