<div class="row g-4 justify-content-center pt-5">
    <div class="col-lg-6">
        <div class="dashboard-card p-4 p-md-5 text-center border-danger border-opacity-10" style="background: linear-gradient(135deg, rgba(220, 53, 69, 0.05), rgba(var(--bg-card-rgb), 1));">
            <div class="d-flex flex-column align-items-center mb-5">
                <div class="feature-icon small bg-danger bg-opacity-10 mb-4 pulse-danger" style="width: 100px; height: 100px;">
                    <i class="fas fa-user-lock text-danger" style="font-size: 2.5rem;"></i>
                </div>
                <h2 class="text-white mb-2 uppercase tracking-widest fw-bold">Account Temporarily Locked</h2>
                <div class="mt-3 p-3 bg-white bg-opacity-5 rounded-4 border border-white border-opacity-5 d-inline-block">
                    <p class="text-secondary smaller text-uppercase mb-1 fw-bold">Safety Cooldown Level</p>
                    <h3 class="text-danger mb-0 font-monospace" id="lock-timer">
                        <span class="counter" wait="<?= $user['locked_until'] - time() ?>"></span>
                    </h3>
                </div>
            </div>

            <div class="text-start mb-5">
                <h6 class="text-white mb-4 small text-uppercase tracking-wider opacity-75"><i class="fas fa-shield-exclamation me-2"></i> How to maintain access?</h6>
                <div class="d-flex flex-column gap-3">
                    <div class="d-flex gap-3 align-items-center p-3 rounded-4 bg-white bg-opacity-5 border border-white border-opacity-5 transition hover-lift-sm">
                        <div class="icon-sm text-success"><i class="fas fa-check-circle"></i></div>
                        <p class="text-secondary small mb-0">Solve captchas carefully to avoid security flags.</p>
                    </div>
                    <div class="d-flex gap-3 align-items-center p-3 rounded-4 bg-white bg-opacity-5 border border-white border-opacity-5 transition hover-lift-sm">
                        <div class="icon-sm text-info"><i class="fas fa-robot"></i></div>
                        <p class="text-secondary small mb-0">Automated scripts and bots are strictly prohibited.</p>
                    </div>
                </div>
            </div>

            <div class="w-100">
                <a href="<?= base_url() ?>" class="btn-primary-custom w-100 py-3 rounded-pill bg-secondary border-0 opacity-50 shadow-none pointer-events-none" id="unlock-btn">
                    <i class="fas fa-hourglass-half me-2"></i> System Restricted
                </a>
            </div>
        </div>
    </div>
</div>

<style>
    .font-monospace { font-family: 'JetBrains Mono', monospace !important; }
    .pulse-danger { animation: lock-pulse 2s infinite ease-in-out; }
    @keyframes lock-pulse {
        0%, 100% { transform: scale(1); box-shadow: 0 0 0 rgba(220, 53, 69, 0); }
        50% { transform: scale(1.05); box-shadow: 0 0 20px rgba(220, 53, 69, 0.2); }
    }
    .hover-lift-sm:hover { transform: translateY(-2px); border-color: rgba(255,255,255,0.1) !important; }
</style>

<script>
    // Simple logic to change button when timer hits zero if needed (though page usually refreshes)
    document.addEventListener('DOMContentLoaded', function() {
        const counter = document.querySelector('.counter');
        const unlockBtn = document.getElementById('unlock-btn');
        if (counter) {
            let waitTime = parseInt(counter.getAttribute('wait'));
            const interval = setInterval(() => {
                if (waitTime <= 0) {
                    clearInterval(interval);
                    unlockBtn.classList.remove('bg-secondary', 'opacity-50', 'pointer-events-none');
                    unlockBtn.classList.add('bg-success');
                    unlockBtn.innerHTML = '<i class="fas fa-unlock me-2"></i> Refresh Access';
                    unlockBtn.style.pointerEvents = 'auto';
                }
                waitTime--;
            }, 1000);
        }
    });
</script>