<?php if ($settings['dashboard_top_ad']) { ?>
    <div class="ads mb-4 text-center">
        <?= $settings['dashboard_top_ad'] ?>
    </div>
<?php } ?>

<div class="row g-4">
    <!-- Notice Bar -->
    <div class="col-12 text-start">
        <div class="alert alert-warning border-0 bg-warning bg-opacity-10 text-warning p-3 rounded-4 mb-2 d-flex align-items-center gap-3">
            <i class="fas fa-history fa-spin"></i>
            <p class="mb-0 small fw-bold">Weekly Leaderboard resets in <span class="text-white"><?= timespan(time(), $leaderboardSettings["leaderboard_date"], 2) ?></span>. Rankings are updated every 10 minutes!</p>
        </div>
    </div>

    <!-- Main Leaderboard Card -->
    <div class="col-12">
        <div class="dashboard-card p-4 p-md-5">
            <div class="d-flex align-items-center gap-3 mb-5">
                <div class="feature-icon small bg-warning bg-opacity-10">
                    <i class="fas fa-medal text-warning"></i>
                </div>
                <div>
                    <h2 class="text-white mb-0">Contest Leaderboards</h2>
                    <p class="text-secondary small mb-0">Compete with other users and win huge rewards at the end of the week.</p>
                </div>
            </div>

            <!-- Custom Tabs (consistent with history) -->
            <ul class="nav nav-pills custom-pills justify-content-center mb-5 gap-2" id="leaderboard-tabs" role="tablist">
                <li class="nav-item">
                    <button class="nav-link active rounded-pill px-4 py-2 border border-white border-opacity-10 text-white" 
                            data-bs-toggle="pill" data-bs-target="#pane-level" type="button">
                        <i class="fas fa-layer-group me-2"></i> Levels
                    </button>
                </li>
                <?php if ($leaderboardSettings['activity_contest_reward'] != ""): ?>
                <li class="nav-item">
                    <button class="nav-link rounded-pill px-4 py-2 border border-white border-opacity-10 text-white" 
                            data-bs-toggle="pill" data-bs-target="#pane-activity" type="button">
                        <i class="fas fa-running me-2"></i> Activity
                    </button>
                </li>
                <?php endif; ?>
                <?php if ($leaderboardSettings['referral_contest_reward'] != ""): ?>
                <li class="nav-item">
                    <button class="nav-link rounded-pill px-4 py-2 border border-white border-opacity-10 text-white" 
                            data-bs-toggle="pill" data-bs-target="#pane-referral" type="button">
                        <i class="fas fa-user-plus me-2"></i> Referral
                    </button>
                </li>
                <?php endif; ?>
                <?php if ($leaderboardSettings['faucet_contest_reward'] != ""): ?>
                <li class="nav-item">
                    <button class="nav-link rounded-pill px-4 py-2 border border-white border-opacity-10 text-white" 
                            data-bs-toggle="pill" data-bs-target="#pane-faucet" type="button">
                        <i class="fas fa-faucet me-2"></i> Faucet
                    </button>
                </li>
                <?php endif; ?>
                <?php if ($leaderboardSettings['shortlink_contest_reward'] != ""): ?>
                <li class="nav-item">
                    <button class="nav-link rounded-pill px-4 py-2 border border-white border-opacity-10 text-white" 
                            data-bs-toggle="pill" data-bs-target="#pane-links" type="button">
                        <i class="fas fa-link me-2"></i> Shortlink
                    </button>
                </li>
                <?php endif; ?>
                <?php if ($leaderboardSettings['offerwall_contest_reward'] != ""): ?>
                <li class="nav-item">
                    <button class="nav-link rounded-pill px-4 py-2 border border-white border-opacity-10 text-white" 
                            data-bs-toggle="pill" data-bs-target="#pane-offers" type="button">
                        <i class="fas fa-briefcase me-2"></i> Offerwall
                    </button>
                </li>
                <?php endif; ?>
            </ul>

            <div class="tab-content">
                <!-- Helper function for rendering table rows (simplified for PHP view) -->
                <?php
                function renderLeaderboardTable($data, $type, $rewardsArr, $settings, $userVal = null, $userLabel = '') {
                    ob_start(); ?>
                    <div class="text-center mb-4">
                        <h4 class="text-white mb-2"><?= $type ?> Leaderboard</h4>
                        <?php if ($userLabel): ?>
                            <p class="text-secondary small"><?= $userLabel ?>: <span class="text-white fw-bold"><?= $userVal ?></span></p>
                        <?php endif; ?>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-dark table-hover border-white border-opacity-5">
                            <thead class="bg-white bg-opacity-5">
                                <tr class="text-secondary small text-uppercase">
                                    <th class="border-0">#Rank</th>
                                    <th class="border-0">User</th>
                                    <th class="border-0 text-center">Score</th>
                                    <?php if ($rewardsArr): ?><th class="border-0 text-end">Reward</th><?php endif; ?>
                                </tr>
                            </thead>
                            <tbody class="text-white border-0">
                                <?php $rank = 0; foreach ($data as $u): $rank++; 
                                    $reward = ($rewardsArr && isset($rewardsArr[$rank-1])) ? $rewardsArr[$rank-1] : 0;
                                    $isTop3 = $rank <= 3;
                                ?>
                                    <tr class="transition <?= $isTop3 ? 'bg-white bg-opacity-5' : '' ?>">
                                        <td class="border-0 py-3">
                                            <?php if ($rank == 1): ?><i class="fas fa-crown text-warning me-2"></i>
                                            <?php elseif ($rank == 2): ?><i class="fas fa-medal text-light me-2"></i>
                                            <?php elseif ($rank == 3): ?><i class="fas fa-medal text-orange me-2" style="color:#cd7f32"></i>
                                            <?php else: ?><span class="opacity-50 ms-4"><?= $rank ?></span><?php endif; ?>
                                        </td>
                                        <td class="border-0 py-3 fw-bold"><?= $u["username"] ?> <span class="badge bg-primary bg-opacity-10 text-primary smaller ms-2">Lvl <?= $u["level"] ?></span></td>
                                        <td class="border-0 py-3 text-center"><?= $u["level"] ?? $u["claims"] ?? $u["ref_count"] ?? $u["faucet_count_tmp"] ?? $u["shortlink_count_tmp"] ?? $u["offerwall_count_tmp"] ?></td>
                                        <?php if ($rewardsArr): ?>
                                            <td class="border-0 py-3 text-end text-success fw-bold"><?= currencyDisplay($reward, $settings) ?></td>
                                        <?php endif; ?>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    <?php return ob_get_clean();
                }
                ?>

                <!-- Level Pane -->
                <div class="tab-pane fade show active" id="pane-level" role="tabpanel">
                    <?= renderLeaderboardTable($topLevel, 'Level', null, $settings) ?>
                </div>

                <!-- Activity Pane -->
                <?php if ($leaderboardSettings['activity_contest_reward'] != ""): ?>
                <div class="tab-pane fade" id="pane-activity" role="tabpanel">
                    <?= renderLeaderboardTable($topClaimer, 'Activity', explode('|', $leaderboardSettings['activity_contest_reward']), $settings, $user['claims'], 'Your Weekly Claims') ?>
                </div>
                <?php endif; ?>

                <!-- Referral Pane -->
                <?php if ($leaderboardSettings['referral_contest_reward'] != ""): ?>
                <div class="tab-pane fade" id="pane-referral" role="tabpanel">
                    <?= renderLeaderboardTable($topReferral, 'Referral', explode('|', $leaderboardSettings['referral_contest_reward']), $settings, $user['ref_count'], 'Your Referrals') ?>
                </div>
                <?php endif; ?>

                <!-- Faucet Pane -->
                <?php if ($leaderboardSettings['faucet_contest_reward'] != ""): ?>
                <div class="tab-pane fade" id="pane-faucet" role="tabpanel">
                    <?= renderLeaderboardTable($topFaucet, 'Faucet', explode('|', $leaderboardSettings['faucet_contest_reward']), $settings, $user['faucet_count_tmp'], 'Your Faucet Claims') ?>
                </div>
                <?php endif; ?>

                <!-- Shortlink Pane -->
                <?php if ($leaderboardSettings['shortlink_contest_reward'] != ""): ?>
                <div class="tab-pane fade" id="pane-links" role="tabpanel">
                    <?= renderLeaderboardTable($topShortlink, 'Shortlink', explode('|', $leaderboardSettings['shortlink_contest_reward']), $settings, $user['shortlink_count_tmp'], 'Your Shortlink Claims') ?>
                </div>
                <?php endif; ?>

                <!-- Offerwall Pane -->
                <?php if ($leaderboardSettings['offerwall_contest_reward'] != ""): ?>
                <div class="tab-pane fade" id="pane-offers" role="tabpanel">
                    <?= renderLeaderboardTable($topOfferwall, 'Offerwall', explode('|', $leaderboardSettings['offerwall_contest_reward']), $settings, $user['offerwall_count_tmp'], 'Your Offerwall Claims') ?>
                </div>
                <?php endif; ?>
            </div>
            
            <div class="mt-4 text-center opacity-50">
                <span id="ct_cypBkovU6jo"></span>
                <span id="ct_cHRhxfMqq1M"></span>
            </div>
        </div>
    </div>
</div>

<style>
    .custom-pills .nav-link {
        background: rgba(255, 255, 255, 0.03);
        transition: var(--transition);
        font-weight: 600;
    }
    .custom-pills .nav-link.active {
        background: var(--primary-gradient) !important;
        box-shadow: var(--shadow-primary);
        border-color: transparent !important;
    }
    .custom-pills .nav-link:hover:not(.active) {
        background: rgba(255, 255, 255, 0.08);
        border-color: var(--primary) !important;
    }
    .table-hover tbody tr:hover {
        background: rgba(255, 255, 255, 0.02) !important;
    }
    .smaller { font-size: 0.7rem; }
</style>