<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8" />
    <title><?= $page ?> | <?= $settings['name'] ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="<?= $settings['description'] ?>" name="description" />
    <link rel="shortcut icon" href="<?= base_url() ?>assets/images/favicon.ico">

    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=JetBrains+Mono:wght@400;700&display=swap" rel="stylesheet">
    
    <!-- CSS Dependencies -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">

    <style>
        :root {
            --primary: #9d4edd;
            --primary-rgb: 157, 78, 221;
            --bg-body: #0a0a0f;
            --bg-card: #14141e;
            --glass-bg: rgba(255, 255, 255, 0.03);
            --glass-border: rgba(255, 255, 255, 0.08);
            --text-main: #ffffff;
            --text-secondary: rgba(255, 255, 255, 0.6);
        }

        body {
            background-color: var(--bg-body);
            background: radial-gradient(circle at top right, rgba(var(--primary-rgb), 0.12) 0%, transparent 40%),
                        radial-gradient(circle at bottom left, rgba(58, 134, 255, 0.08) 0%, transparent 40%),
                        var(--bg-body);
            color: var(--text-main);
            font-family: 'Outfit', sans-serif;
            margin: 0;
            overflow-x: hidden;
            scroll-behavior: smooth;
        }

        .navbar {
            background: rgba(10, 10, 15, 0.8) !important;
            backdrop-filter: blur(20px);
            border-bottom: 1px solid var(--glass-border);
            padding: 15px 0;
            transition: all 0.3s ease;
        }
        .navbar.sticky { padding: 10px 0; }

        .nav-link {
            color: var(--text-secondary) !important;
            font-weight: 500;
            padding: 0.5rem 1.2rem !important;
            transition: color 0.3s ease;
        }
        .nav-link:hover, .nav-link.active { color: var(--primary) !important; }

        .section-padding { padding: 100px 0; }

        .dashboard-card {
            background: var(--glass-bg);
            backdrop-filter: blur(20px);
            border: 1px solid var(--glass-border);
            border-radius: 1.5rem;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }
        .dashboard-card:hover { transform: translateY(-5px); border-color: rgba(var(--primary-rgb), 0.3); }

        .text-gradient {
            background: linear-gradient(to right, #ffffff, var(--primary));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        .btn-primary-custom {
            background: linear-gradient(135deg, var(--primary), #7b2cbf);
            border: none;
            color: white;
            padding: 12px 35px;
            border-radius: 50px;
            font-weight: 600;
            transition: all 0.3s ease;
            box-shadow: 0 10px 20px rgba(var(--primary-rgb), 0.3);
            text-decoration: none;
            display: inline-block;
        }
        .btn-primary-custom:hover { transform: translateY(-2px); box-shadow: 0 15px 25px rgba(var(--primary-rgb), 0.4); color: white; }

        .feature-icon {
            width: 60px; height: 60px;
            background: rgba(var(--primary-rgb), 0.1);
            color: var(--primary);
            border-radius: 50%;
            display: flex;
            align-items: center; justify-content: center;
            font-size: 1.5rem;
            margin-bottom: 1.5rem;
        }

        .lottery-progress {
            background: rgba(255,255,255,0.05);
            padding: 2.5rem;
            border-radius: 2rem;
            border: 1px solid rgba(var(--primary-rgb), 0.2);
            box-shadow: 0 0 30px rgba(var(--primary-rgb), 0.1);
        }

        .stat-icon { font-size: 3rem; opacity: 0.5; margin-bottom: 1rem; }

        footer {
            background: #050508;
            border-top: 1px solid var(--glass-border);
            padding: 60px 0;
            color: var(--text-secondary);
        }
        footer a { color: var(--primary); text-decoration: none; }

        .ico-countdown span {
            font-family: 'JetBrains Mono', monospace;
            font-size: 2.5rem;
            font-weight: 700;
            margin: 0 5px;
            color: var(--text-main);
        }

        .floating-anim { animation: float 6s ease-in-out infinite; }
        @keyframes float {
            0%, 100% { transform: translateY(0); }
            50% { transform: translateY(-30px); }
        }
    </style>
</head>
<body data-bs-spy="scroll" data-bs-target="#topnav" data-bs-offset="100">

    <nav class="navbar navbar-expand-lg fixed-top" id="topnav">
        <div class="container">
            <a class="navbar-brand" href="<?= base_url() ?>">
                <img src="<?= site_url('assets/images/logo.png') ?>" alt="Logo" height="40">
            </a>
            <button class="navbar-toggler border-0 text-white" type="button" data-bs-toggle="collapse" data-bs-target="#navContent">
                <i class="fas fa-bars"></i>
            </button>
            <div class="collapse navbar-collapse" id="navContent">
                <ul class="navbar-nav ms-auto mb-2 mb-lg-0 align-items-center">
                    <li class="nav-item"><a class="nav-link px-3 active" href="#home">Home</a></li>
                    <li class="nav-item"><a class="nav-link px-3" href="#features">Features</a></li>
                    <li class="nav-item"><a class="nav-link px-3" href="#statistics">Stats</a></li>
                    <li class="nav-item"><a class="nav-link px-3" href="#methods">Methods</a></li>
                    <li class="nav-item ms-lg-3"><a class="btn-primary-custom py-2" href="<?= site_url('login') ?>">Login</a></li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Hero / Lottery -->
    <section class="section-padding" id="home" style="padding-top: 150px;">
        <div class="container">
            <div class="row align-items-center g-5">
                <div class="col-lg-7 animate__animated animate__fadeInLeft">
                    <h1 class="display-3 fw-bold mb-4">Earn Crypto at the <br><span class="text-gradient">Speed of Light</span></h1>
                    <p class="lead text-secondary mb-5">Join our high-performance reward engine. Earn multiple currencies through instant tasks, global offerwalls, and recurring faucets.</p>
                    <div class="d-flex gap-3 flex-wrap">
                        <a href="<?= site_url('register') ?>" class="btn-primary-custom">Initialize Earning</a>
                        <a href="#features" class="btn btn-outline-light rounded-pill px-4 py-3 border-opacity-25 hover-lift">Learn More</a>
                    </div>
                </div>
                
                <?php if ($settings['lottery_status'] == 'on'): ?>
                <div class="col-lg-5 animate__animated animate__zoomIn">
                    <div class="lottery-progress text-center">
                        <h6 class="text-secondary text-uppercase tracking-widest mb-4 fw-bold">Active Jackpot Pool</h6>
                        <h2 class="text-white display-5 fw-bold mb-4 text-gradient">$<?= number_format($lotteryReward, 2) ?> USD</h2>
                        <div class="mb-4">
                            <p class="smaller text-secondary mb-2">TIME REMAINING</p>
                            <div data-countdown="<?= date('Y/m/d H:i:s', $settings['lottery_date']) ?>" class="ico-countdown"></div>
                        </div>
                        <a href="<?= site_url('lottery') ?>" class="btn-primary-custom w-100">Get Your Lucky Ticket</a>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </section>

    <!-- Features -->
    <section class="section-padding" id="features">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="display-5 fw-bold mb-3">Core <span class="text-gradient">Infrastructure</span></h2>
                <p class="text-secondary">Explore our diversified earning ecosystems.</p>
            </div>
            <div class="row g-4">
                <?php 
                $features = [
                    ['id' => 'faucet', 'name' => 'Faucet', 'icon' => 'faucet', 'desc' => "Claim rewards every ".floor($settings['timer'] / 60)." mins."],
                    ['id' => 'shortlink', 'name' => 'Shortlinks', 'icon' => 'link', 'desc' => 'Visit secure links to earn coins and energy.'],
                    ['id' => 'ptc', 'name' => 'PTC Ads', 'icon' => 'mouse-pointer', 'desc' => 'Earn by viewing sponsor sites instantly.'],
                    ['id' => 'offerwall', 'name' => 'Offerwalls', 'icon' => 'tasks', 'desc' => 'Complete high-paying surveys & offers.'],
                    ['id' => 'auto', 'name' => 'Autofaucet', 'icon' => 'bolt', 'desc' => 'Automate your earnings with Energy.'],
                    ['id' => 'dice', 'name' => 'Provably Fair', 'icon' => 'dice', 'desc' => 'Double your stake in our luck-based games.']
                ];
                foreach ($features as $f): 
                    if ($settings[$f['id'].'_status'] ?? 'on' == 'off') continue;
                ?>
                <div class="col-md-6 col-lg-4">
                    <div class="dashboard-card p-5 h-100">
                        <div class="feature-icon"><i class="fas fa-<?= $f['icon'] ?>"></i></div>
                        <h4 class="text-white mb-3 fw-bold"><?= $f['name'] ?></h4>
                        <p class="text-secondary small mb-0"><?= $f['desc'] ?></p>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>

    <!-- Stats -->
    <section class="section-padding bg-black bg-opacity-20" id="statistics">
        <div class="container">
            <div class="row text-center g-5">
                <div class="col-md-4">
                    <div class="stat-icon text-primary"><i class="fas fa-users-crown"></i></div>
                    <h2 class="fw-bold mb-1"><?= number_format($stat['total_user']) ?></h2>
                    <p class="text-secondary text-uppercase tracking-wider small">Global Citizens</p>
                </div>
                <div class="col-md-4">
                    <div class="stat-icon text-info"><i class="fas fa-hand-holding-dollar"></i></div>
                    <h2 class="fw-bold mb-1">$<?= number_format($stat['earning'], 2) ?></h2>
                    <p class="text-secondary text-uppercase tracking-wider small">USDT Distributed</p>
                </div>
                <div class="col-md-4">
                    <div class="stat-icon text-success"><i class="fas fa-file-invoice-dollar"></i></div>
                    <h2 class="fw-bold mb-1"><?= number_format($stat['withdrawals']) ?></h2>
                    <p class="text-secondary text-uppercase tracking-wider small">Successful Payouts</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Methods -->
    <section class="section-padding" id="methods">
        <div class="container text-center">
            <h2 class="fw-bold mb-5">Supported <span class="text-gradient">Gateways</span></h2>
            <div class="d-flex flex-wrap justify-content-center gap-5 items-center opacity-75">
                <?php foreach ($methods as $method): ?>
                <div class="method-item d-flex flex-column align-items-center gap-2 hover-lift transition">
                    <img src="<?= site_url('assets/images/currencies/' . strtolower($method['code']) . '.png') ?>" alt="<?= $method['name'] ?>" height="50">
                    <span class="smaller text-secondary fw-bold"><?= $method['code'] ?></span>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>

    <!-- Proofs -->
    <section class="section-padding" id="proofs">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="fw-bold">Payment <span class="text-gradient">Veracity</span></h2>
                <p class="text-secondary">Immutable records of our most recent distributions.</p>
            </div>
            <div class="dashboard-card p-4 overflow-hidden">
                <div class="table-responsive">
                    <table class="table table-dark table-hover text-center align-middle mb-0">
                        <thead class="bg-white bg-opacity-5">
                            <tr class="text-secondary small text-uppercase">
                                <th class="border-0 px-4">Recipient</th>
                                <th class="border-0">Method</th>
                                <th class="border-0 text-end px-4">Settlement</th>
                            </tr>
                        </thead>
                        <tbody class="border-0">
                            <?php foreach ($withdrawHistory as $wd): ?>
                            <tr>
                                <td class="text-start px-4 fw-bold">
                                    <span class="text-white"><?= $wd["username"] ?></span>
                                    <div class="smaller text-secondary font-monospace opacity-50"><?= substr($wd["wallet"], 0, 8) ?>...<?= substr($wd["wallet"], -8) ?></div>
                                </td>
                                <td><span class="badge bg-white bg-opacity-5 border border-white border-opacity-10 px-3 py-2 rounded-pill"><?= format_money($wd["amount"]) ?> USD</span></td>
                                <td class="text-end px-4 text-success fw-bold"><i class="fas fa-check-double me-1"></i> Finalized</td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </section>

    <footer class="text-center">
        <div class="container">
            <img src="<?= site_url('assets/images/logo.png') ?>" alt="Logo" height="40" class="mb-4 opacity-75">
            <p class="mb-4">Accelerating the global adoption of micro-cryptocurrency through <br> transparent and inclusive rewarding systems.</p>
            <div class="d-flex justify-content-center gap-4 mb-5">
                <a href="#"><i class="fab fa-telegram fa-lg"></i></a>
                <a href="#"><i class="fab fa-twitter fa-lg"></i></a>
                <a href="#"><i class="fab fa-discord fa-lg"></i></a>
            </div>
            <p class="smaller opacity-50 mb-0">&copy; <?= date('Y') ?> <strong><?= $settings['name'] ?></strong>. Empowered by Vie Faucet Protocol.</p>
        </div>
    </footer>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="<?= base_url() ?>assets/libs/jquery/jquery.min.js"></script>
    <script src="<?= base_url() ?>assets/libs/jquery-countdown/jquery.countdown.min.js"></script>
    
    <script>
        $(document).ready(function() {
            $('[data-countdown]').each(function() {
                var $this = $(this), finalDate = $(this).data('countdown');
                $this.countdown(finalDate, function(event) {
                    $this.html(event.strftime('<span>%D</span> : <span>%H</span> : <span>%M</span> : <span>%S</span>'));
                });
            });
            
            $(window).scroll(function() {
                if ($(this).scrollTop() > 50) { $('.navbar').addClass('sticky'); }
                else { $('.navbar').removeClass('sticky'); }
            });
        });
    </script>
    
    <?php include 'adblock.php'; ?>
</body>
</html>