<?php if ($settings['dashboard_top_ad']) { ?>
    <div class="ads mb-4 text-center">
        <?= $settings['dashboard_top_ad'] ?>
    </div>
<?php } ?>

<div class="row g-4">
    <div class="col-12">
        <div class="dashboard-card p-4 p-md-5">
            <div class="d-flex align-items-center gap-3 mb-5">
                <div class="feature-icon small bg-primary bg-opacity-10">
                    <i class="fas fa-history text-gradient"></i>
                </div>
                <div>
                    <h2 class="text-white mb-0">Earning History</h2>
                    <p class="text-secondary small mb-0">Track your activities, withdrawals and offerwall completions.</p>
                </div>
            </div>

            <!-- Custom Tab Style -->
            <ul class="nav nav-pills custom-pills justify-content-center mb-5 gap-2" id="history-tabs" role="tablist">
                <li class="nav-item">
                    <button class="nav-link active rounded-pill px-4 py-2 border border-white border-opacity-10 text-white" 
                            id="withdraw-tab" data-bs-toggle="pill" data-bs-target="#pane-withdraw" type="button">
                        <i class="fas fa-wallet me-2"></i> Withdrawals
                    </button>
                </li>
                <li class="nav-item">
                    <button class="nav-link rounded-pill px-4 py-2 border border-white border-opacity-10 text-white" 
                            id="task-tab" data-bs-toggle="pill" data-bs-target="#pane-task" type="button">
                        <i class="fas fa-tasks me-2"></i> Tasks
                    </button>
                </li>
                <li class="nav-item">
                    <button class="nav-link rounded-pill px-4 py-2 border border-white border-opacity-10 text-white" 
                            id="offer-tab" data-bs-toggle="pill" data-bs-target="#pane-offer" type="button">
                        <i class="fas fa-gift me-2"></i> Offerwalls
                    </button>
                </li>
            </ul>

            <div class="tab-content" id="history-content">
                <!-- Withdrawal History -->
                <div class="tab-pane fade show active" id="pane-withdraw" role="tabpanel">
                    <div class="table-responsive">
                        <table class="table table-dark table-hover border-white border-opacity-5">
                            <thead class="bg-white bg-opacity-5">
                                <tr class="text-secondary small text-uppercase">
                                    <th class="border-0">#ID</th>
                                    <th class="border-0">Status</th>
                                    <th class="border-0 text-center">Amount</th>
                                    <th class="border-0 text-end">Date</th>
                                </tr>
                            </thead>
                            <tbody class="text-white border-0">
                                <?php if (empty($withdrawals_history)): ?>
                                    <tr><td colspan="4" class="text-center py-5 text-secondary italic border-0">No withdrawals found.</td></tr>
                                <?php else: ?>
                                    <?php foreach ($withdrawals_history as $value): ?>
                                        <tr class="transition">
                                            <td class="border-0 py-3 font-monospace small">#<?= $value["id"] ?></td>
                                            <td class="border-0 py-3">
                                                <?php if ($value['type'] == 0): ?>
                                                    <span class="badge rounded-pill bg-info bg-opacity-10 text-info px-3 py-2">Pending</span>
                                                <?php elseif ($value['type'] == 1): ?>
                                                    <span class="badge rounded-pill bg-success bg-opacity-10 text-success px-3 py-2">Approved</span>
                                                <?php else: ?>
                                                    <span class="badge rounded-pill bg-danger bg-opacity-10 text-danger px-3 py-2">Denied</span>
                                                <?php endif; ?>
                                            </td>
                                            <td class="border-0 py-3 text-center fw-bold">
                                                <?= currencyDisplay($value["amount"], $settings) ?>
                                            </td>
                                            <td class="border-0 py-3 text-end text-secondary small">
                                                <?= timespan($value["claim_time"], time(), 1) ?> ago
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Task History -->
                <div class="tab-pane fade" id="pane-task" role="tabpanel">
                    <div class="table-responsive">
                        <table class="table table-dark table-hover border-white border-opacity-5">
                            <thead class="bg-white bg-opacity-5">
                                <tr class="text-secondary small text-uppercase">
                                    <th class="border-0">#ID</th>
                                    <th class="border-0">Task Description</th>
                                    <th class="border-0 text-center">Reward</th>
                                    <th class="border-0 text-end">Date</th>
                                </tr>
                            </thead>
                            <tbody class="text-white border-0">
                                <?php if (empty($task_history)): ?>
                                    <tr><td colspan="4" class="text-center py-5 text-secondary italic border-0">No tasks found.</td></tr>
                                <?php else: ?>
                                    <?php foreach ($task_history as $value): ?>
                                        <tr class="transition">
                                            <td class="border-0 py-3 font-monospace small">#<?= $value["id"] ?></td>
                                            <td class="border-0 py-3 fw-bold"><?= $value['name'] ?></td>
                                            <td class="border-0 py-3 text-center text-success fw-bold">
                                                +<?= currencyDisplay($value["usd_reward"], $settings) ?>
                                            </td>
                                            <td class="border-0 py-3 text-end text-secondary small">
                                                <?= timespan($value["claim_time"], time(), 1) ?> ago
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Offerwall History -->
                <div class="tab-pane fade" id="pane-offer" role="tabpanel">
                    <div class="table-responsive">
                        <table class="table table-dark table-hover border-white border-opacity-5">
                            <thead class="bg-white bg-opacity-5">
                                <tr class="text-secondary small text-uppercase text-nowrap">
                                    <th class="border-0">Network</th>
                                    <th class="border-0">Rewards</th>
                                    <th class="border-0">Status</th>
                                    <th class="border-0">Release Info</th>
                                    <th class="border-0 text-end">Completed</th>
                                </tr>
                            </thead>
                            <tbody class="text-white border-0">
                                <?php if (empty($offerwall_history)): ?>
                                    <tr><td colspan="5" class="text-center py-5 text-secondary italic border-0">No offers completed yet.</td></tr>
                                <?php else: ?>
                                    <?php foreach ($offerwall_history as $value): 
                                        $release = timespan(time(), $value["available_at"], 2);
                                        $released = ($release == '1 Second' || time() >= $value["available_at"]);
                                    ?>
                                        <tr class="transition">
                                            <td class="border-0 py-3">
                                                <div class="d-flex align-items-center gap-2">
                                                    <div class="rounded-circle bg-white bg-opacity-10 d-flex align-items-center justify-content-center" style="width: 28px; height: 28px;">
                                                        <i class="fas fa-network-wired smaller text-primary"></i>
                                                    </div>
                                                    <span class="fw-bold"><?= ucfirst($value["offerwall"]) ?></span>
                                                </div>
                                            </td>
                                            <td class="border-0 py-3 fw-bold text-success">+<?= currencyDisplay($value["amount"], $settings) ?></td>
                                            <td class="border-0 py-3">
                                                <?php if ($value['status'] == 0): ?>
                                                    <span class="badge rounded-pill bg-info bg-opacity-10 text-info px-2 py-1 small">Pending</span>
                                                <?php elseif ($value['status'] == 1): ?>
                                                    <span class="badge rounded-pill bg-danger bg-opacity-10 text-danger px-2 py-1 small">Cancelled</span>
                                                <?php else: ?>
                                                    <span class="badge rounded-pill bg-success bg-opacity-10 text-success px-2 py-1 small">Approved</span>
                                                <?php endif; ?>
                                            </td>
                                            <td class="border-0 py-3">
                                                <?php if ($released): ?>
                                                    <span class="text-success small fw-bold"><i class="fas fa-check-double me-1"></i> Released</span>
                                                <?php else: ?>
                                                    <span class="text-warning small italic"><i class="fas fa-hourglass-start me-1"></i> <?= $release ?> left</span>
                                                <?php endif; ?>
                                            </td>
                                            <td class="border-0 py-3 text-end text-secondary small">
                                                <?= timespan($value["claim_time"], time(), 1) ?> ago
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .custom-pills .nav-link {
        background: rgba(255, 255, 255, 0.03);
        transition: var(--transition);
        font-weight: 600;
    }
    .custom-pills .nav-link.active {
        background: var(--primary-gradient) !important;
        box-shadow: var(--shadow-primary);
        border-color: transparent !important;
    }
    .custom-pills .nav-link:hover:not(.active) {
        background: rgba(255, 255, 255, 0.08);
        border-color: var(--primary) !important;
    }
    .table-hover tbody tr:hover {
        background: rgba(255, 255, 255, 0.02) !important;
    }
    .smaller { font-size: 0.8rem; }
    .italic { font-style: italic; }
</style>