<div class="row g-4 justify-content-center pt-5">
    <div class="col-lg-6">
        <div class="dashboard-card p-4 p-md-5 text-center">
            <div class="d-flex flex-column align-items-center mb-5">
                <div class="feature-icon small bg-danger bg-opacity-10 mb-3" style="width: 80px; height: 80px;">
                    <i class="fas fa-user-shield text-danger" style="font-size: 2.5rem;"></i>
                </div>
                <h2 class="text-white mb-2 uppercase tracking-widest">Security Firewall</h2>
                <p class="text-secondary small">Your account activity triggered our security filter. Please solve the captcha below to verify you are a human.</p>
            </div>

            <div class="alert alert-warning border-0 bg-warning bg-opacity-10 text-warning p-3 rounded-4 mb-4 small fw-bold">
                <i class="fas fa-exclamation-triangle me-2"></i> Verification Required
            </div>

            <?php if (isset($_SESSION['message'])) echo '<div class="mb-4 text-start">' . $_SESSION['message'] . '</div>'; ?>

            <form action="<?= site_url('firewall/verify') ?>" method="POST" class="mt-4">
                <input type="hidden" name="captchaType" value="<?= $captcha['name'] ?>">
                <input type="hidden" name="<?= $csrf_name ?>" value="<?= $csrf_hash ?>">

                <div class="captcha-box p-4 bg-white bg-opacity-5 rounded-4 border border-white border-opacity-5 mb-5 d-flex align-items-center justify-content-center">
                    <?= $captcha['code'] ?>
                </div>

                <div class="w-100">
                    <button type="submit" class="btn-primary-custom w-100 py-3 rounded-pill shadow-lg">
                        <i class="fas fa-unlock-alt me-2"></i> Unlock My Account
                    </button>
                </div>
            </form>
            
            <p class="text-secondary smaller mt-4 opacity-75">This is a mandatory security check to prevent bot abuse.</p>
        </div>
    </div>
</div>

<style>
    .captcha-box { min-height: 100px; }
    .smaller { font-size: 0.75rem; }
</style>