<?php if ($settings['ptc_top_ad'] ?? false) { ?>
    <div class="ads mb-4 text-center">
        <?= $settings['ptc_top_ad'] ?>
    </div>
<?php } ?>

<div class="row g-4 text-start">
    <div class="col-12 mb-2">
        <h2 class="text-white mb-1">Extra PTC Ads</h2>
        <p class="text-secondary small">View sponsored websites and earning additional rewards from our partners.</p>
    </div>

    <?php if (isset($_SESSION['message'])) echo '<div class="col-12">' . $_SESSION['message'] . '</div>'; ?>
    
    <!-- Admin Debug Info -->
    <?php if ($this->session->userdata('role') == 'administrator' && isset($bitcotasks_error)): ?>
        <div class="col-12">
            <div class="dashboard-card p-4 border-info border-opacity-25 bg-info bg-opacity-5">
                <h5 class="text-info mb-3 small fw-bold text-uppercase"><i class="fas fa-bug me-2"></i> Admin Debug Info</h5>
                <div class="font-monospace smaller text-secondary">
                    <p class="mb-1"><strong>API URL:</strong> <?= isset($debug_url) ? $debug_url : 'N/A' ?></p>
                    <p class="mb-1"><strong>Error:</strong> <?= $bitcotasks_error ?></p>
                    <div class="mt-2 p-2 bg-black bg-opacity-20 rounded border border-white border-opacity-5 overflow-auto" style="max-height: 150px;">
                        <?= isset($debug_response) ? htmlspecialchars($debug_response) : 'No response' ?>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php if (isset($bitcotasks_ptc) && count($bitcotasks_ptc) > 0): ?>
        <?php
        $total = count($bitcotasks_ptc);
        $insert_pos = (int) floor($total / 2);
        $i = 0;
        ?>

        <?php foreach ($bitcotasks_ptc as $bt_ad): ?>
            <?php if ($i == $insert_pos): ?>
                <!-- Sponsored PTC Ad -->
                <div class="col-lg-6 col-xl-4">
                    <div class="dashboard-card h-100 p-4 hover-lift transition d-flex flex-column justify-content-between border-info border-opacity-10" style="background: linear-gradient(135deg, rgba(13, 110, 253, 0.05), rgba(var(--bg-card-rgb), 1));">
                        <div>
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <h5 class="text-white mb-0">Sponsored Ad</h5>
                                <span class="badge rounded-pill bg-info bg-opacity-10 text-info border border-info border-opacity-10 px-2 py-1 smaller">BONUS</span>
                            </div>
                            <p class="text-secondary small mb-4">Support our platform by interacting with this sponsored content.</p>

                            <div class="ptc-external-ad-box text-center p-3 bg-white bg-opacity-5 rounded-4 border border-white border-opacity-5 mb-4">
                                <ins class="6917766b57295e26a9b98c1a" style="display:inline-block;width:1px;height:1px;"></ins>
                                <script>
                                    !function(e,n,c,t,o,r,d){
                                    !function e(n,c,t,o,r,m,d,s,a){
                                    s=c.getElementsByTagName(t)[0],
                                    (a=c.createElement(t)).async=!0,
                                    a.src="https://"+r[m]+"/js/"+o+".js?v="+d,
                                    a.onerror=function(){
                                    a.remove(),
                                    (m+=1)>=r.length||e(n,c,t,o,r,m)
                                    },
                                    s.parentNode.insertBefore(a,s)
                                    }
                                    (window,document,"script","6917766b57295e26a9b98c1a",["cdn.bmcdn6.com"],0,new Date().getTime())
                                    }();
                                </script>
                            </div>
                        </div>

                        <button class="btn btn-dark w-100 py-2 rounded-pill opacity-50 border-0" disabled>
                            Internal Ad Rendering
                        </button>
                    </div>
                </div>
            <?php endif; ?>

            <div class="col-lg-6 col-xl-4">
                <div class="dashboard-card h-100 p-4 hover-lift transition d-flex flex-column justify-content-between">
                    <div>
                        <?php if (!empty($bt_ad['image'])): ?>
                            <div class="text-center mb-3 bg-white bg-opacity-5 rounded-4 p-2 overflow-hidden" style="height: 120px;">
                                <img src="<?= $bt_ad['image'] ?>" class="img-fluid h-100 object-fit-contain" alt="<?= $bt_ad['title'] ?>">
                            </div>
                        <?php endif; ?>

                        <div class="d-flex justify-content-between align-items-start mb-2">
                            <h5 class="text-white mb-0"><?= $bt_ad['title'] ?></h5>
                            <?php if ($bt_ad['boosted_campaign']): ?>
                                <span class="badge rounded-pill bg-success bg-opacity-10 text-success border border-success border-opacity-10 py-1 px-2 smaller">
                                    <i class="fas fa-rocket me-1"></i>
                                </span>
                            <?php endif; ?>
                        </div>
                        <p class="text-secondary smaller mb-4 line-clamp-2"><?= $bt_ad['description'] ?></p>

                        <div class="d-flex flex-wrap gap-2 mb-4">
                            <span class="badge rounded-pill bg-white bg-opacity-5 text-warning border border-white border-opacity-10 px-2 py-1">
                                <i class="fas fa-coins me-1"></i> <?= $bt_ad['reward'] ?> <?= $bt_ad['currency_name'] ?>
                            </span>
                            <span class="badge rounded-pill bg-white bg-opacity-5 text-info border border-white border-opacity-10 px-2 py-1">
                                <i class="fas fa-clock me-1"></i> <?= $bt_ad['duration'] ?>s
                            </span>
                            <span class="badge rounded-pill bg-white bg-opacity-5 text-secondary border border-white border-opacity-10 px-2 py-1">
                                <i class="fas fa-external-link-alt me-1"></i> <?= strtoupper($bt_ad['ad_type']) ?>
                            </span>
                        </div>
                    </div>

                    <button onclick="window.location = '<?= $bt_ad['url'] ?>'" class="btn-primary-custom w-100 py-2">
                        View Website
                    </button>
                </div>
            </div>

            <?php $i++; ?>
        <?php endforeach; ?>
    <?php elseif (isset($bitcotasks_error)): ?>
        <div class="col-12 py-5 text-center">
            <div class="dashboard-card py-5">
                <i class="fas fa-exclamation-circle fa-4x text-danger opacity-25 mb-4"></i>
                <h3 class="text-white">Partner API Error</h3>
                <p class="text-secondary"><?= $bitcotasks_error ?></p>
            </div>
        </div>
    <?php else: ?>
        <div class="col-12 py-5 text-center">
            <div class="dashboard-card py-5">
                <i class="fas fa-eye-slash fa-4x text-muted mb-4 opacity-25"></i>
                <h4 class="text-white">No extra PTC ads available</h4>
                <p class="text-secondary">Try checking back in a few hours for new ads.</p>
            </div>
        </div>
    <?php endif; ?>
</div>

<?php if ($settings['ptc_footer_ad'] ?? false) { ?>
    <div class="ads mt-4 text-center"><?= $settings['ptc_footer_ad'] ?></div>
<?php } ?>

<style>
    .smaller { font-size: 0.7rem; }
    .line-clamp-2 {
        display: -webkit-box;
        -webkit-line-clamp: 2;
        -webkit-box-orient: vertical;
        overflow: hidden;
    }
</style>
