<?php if ($settings['shortlinks_top_ad'] ?? false) { ?>
    <div class="ads mb-4 text-center">
        <?= $settings['shortlinks_top_ad'] ?>
    </div>
<?php } ?>

<div class="row g-4 text-start">
    <div class="col-12 mb-2">
        <h2 class="text-white mb-1">Extra Shortlinks</h2>
        <p class="text-secondary small">Complete additional tasks from our partners to earn extra rewards.</p>
    </div>

    <!-- notice -->
    <?php if (isset($_SESSION['message'])) echo '<div class="col-12">' . $_SESSION['message'] . '</div>'; ?>
    
    <!-- Admin Debug Info -->
    <?php if ($this->session->userdata('role') == 'administrator' && isset($bitcotasks_error)): ?>
        <div class="col-12">
            <div class="dashboard-card p-4 border-info border-opacity-25 bg-info bg-opacity-5">
                <h5 class="text-info mb-3 small fw-bold text-uppercase"><i class="fas fa-bug me-2"></i> Admin Debug Info</h5>
                <div class="font-monospace smaller text-secondary">
                    <p class="mb-1"><strong>API URL:</strong> <?= isset($debug_url) ? $debug_url : 'N/A' ?></p>
                    <p class="mb-1"><strong>Error:</strong> <?= $bitcotasks_error ?></p>
                    <div class="mt-2 p-2 bg-black bg-opacity-20 rounded border border-white border-opacity-5 overflow-auto" style="max-height: 150px;">
                        <?= isset($debug_response) ? htmlspecialchars($debug_response) : 'No response' ?>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php if (isset($bitcotasks_sl) && count($bitcotasks_sl) > 0): ?>
        <?php foreach ($bitcotasks_sl as $sl): ?>
            <div class="col-lg-6 col-xl-4">
                <div class="dashboard-card h-100 p-4 hover-lift transition d-flex flex-column justify-content-between">
                    <div>
                        <div class="d-flex justify-content-between align-items-start mb-3">
                            <h5 class="text-white mb-0"><?= $sl['title'] ?></h5>
                            <?php if ($sl['boosted_campaign']): ?>
                                <span class="badge rounded-pill bg-success bg-opacity-10 text-success border border-success border-opacity-10 py-1 px-2 smaller pulse">
                                    <i class="fas fa-rocket me-1"></i> Boosted
                                </span>
                            <?php endif; ?>
                        </div>

                        <div class="d-flex flex-wrap gap-2 mb-4">
                            <span class="badge rounded-pill bg-white bg-opacity-5 text-warning border border-white border-opacity-10 px-2 py-1">
                                <i class="fas fa-coins me-1"></i> <?= $sl['reward'] ?> <?= $sl['currency_name'] ?>
                            </span>
                            <span class="badge rounded-pill bg-white bg-opacity-5 text-secondary border border-white border-opacity-10 px-2 py-1">
                                <i class="fas fa-sync me-1"></i> <?= $sl['available'] ?>/<?= $sl['limit'] ?>
                            </span>
                        </div>
                        
                        <div class="mb-4">
                            <div class="d-flex justify-content-between mb-1 smaller">
                                <span class="text-secondary">Completion Rate</span>
                                <span class="text-white fw-bold"><?= $sl['completion_rate'] ?>%</span>
                            </div>
                            <div class="progress rounded-pill bg-white bg-opacity-5" style="height: 6px;">
                                <div class="progress-bar bg-info rounded-pill" role="progressbar" style="width: <?= $sl['completion_rate'] ?>%"></div>
                            </div>
                        </div>
                    </div>

                    <button onclick="window.location = '<?= $sl['url'] ?>'" class="btn-primary-custom w-100 py-2">
                        Visit Shortlink
                    </button>
                </div>
            </div>
        <?php endforeach; ?>
    <?php elseif (isset($bitcotasks_error)): ?>
        <div class="col-12 py-5 text-center">
            <div class="dashboard-card py-5">
                <i class="fas fa-exclamation-circle fa-4x text-danger opacity-25 mb-4"></i>
                <h3 class="text-white">Partner API Error</h3>
                <p class="text-secondary"><?= $bitcotasks_error ?></p>
            </div>
        </div>
    <?php else: ?>
        <div class="col-12 py-5 text-center">
            <div class="dashboard-card py-5">
                <i class="fas fa-link-slash fa-4x text-muted mb-4 opacity-25"></i>
                <h4 class="text-white">No extra shortlinks available</h4>
                <p class="text-secondary">Try checking back in a few hours for new tasks.</p>
            </div>
        </div>
    <?php endif; ?>
</div>

<?php if ($settings['shortlinks_footer_ad'] ?? false) { ?>
    <div class="ads mt-4 text-center"><?= $settings['shortlinks_footer_ad'] ?></div>
<?php } ?>

<style>
    .smaller { font-size: 0.7rem; }
    .pulse { animation: sl-pulse 2s infinite ease-in-out; }
    @keyframes sl-pulse {
        0%, 100% { transform: scale(1); opacity: 1; }
        50% { transform: scale(1.05); opacity: 0.8; }
    }
</style>
