<div class="row g-4 justify-content-center">
    <!-- Main Game Card -->
    <div class="col-lg-12">
        <div class="dashboard-card p-4 p-md-5">
            <div class="d-flex align-items-center justify-content-between mb-5 flex-wrap gap-3">
                <div class="d-flex align-items-center gap-3">
                    <div class="feature-icon small bg-primary bg-opacity-10">
                        <i class="fas fa-dice text-gradient"></i>
                    </div>
                    <div>
                        <h2 class="text-white mb-0 uppercase tracking-widest">Dice Game</h2>
                        <p class="text-secondary small mb-0">Test your luck and strategy in a provably fair game.</p>
                    </div>
                </div>
                <div class="balance-display py-2 px-4 rounded-pill bg-white bg-opacity-5 border border-white border-opacity-10">
                    <span class="text-secondary small text-uppercase fw-bold me-2">Your Balance:</span>
                    <span class="text-white fw-bold" id="balance"><?= currencyDisplay($user['balance'], $settings) ?></span>
                </div>
            </div>

            <form id="diceForm">
                <div class="row g-5">
                    <!-- Controls Column -->
                    <div class="col-lg-6">
                        <div class="d-flex flex-column gap-4">
                            <div>
                                <label class="text-secondary small text-uppercase fw-bold mb-2 d-block">Win Chance</label>
                                <div class="input-group">
                                    <span class="input-group-text border-0 bg-white bg-opacity-5 text-secondary px-3"><i class="fas fa-percent small"></i></span>
                                    <input type="number" id="multiplier" class="form-control border-0 bg-white bg-opacity-5 text-white p-3" value="49.5" min="2" max="97" step="0.1">
                                </div>
                            </div>

                            <div>
                                <label class="text-secondary small text-uppercase fw-bold mb-2 d-block">Estimated Profit</label>
                                <div class="input-group">
                                    <span class="input-group-text border-0 bg-white bg-opacity-10 text-success px-3"><i class="fas fa-trophy small"></i></span>
                                    <input type="text" id="profit" class="form-control border-0 bg-white bg-opacity-10 text-success p-3 fw-bold" readonly>
                                </div>
                            </div>

                            <div>
                                <label class="text-secondary small text-uppercase fw-bold mb-2 d-block">Bet Amount</label>
                                <div class="input-group">
                                    <span class="input-group-text border-0 bg-white bg-opacity-5 text-secondary px-3"><i class="fas fa-coins small"></i></span>
                                    <input type="number" class="form-control border-0 bg-white bg-opacity-5 text-white p-3" id="betAmount" 
                                           value="<?= $settings['min_bet'] / $settings['currency_rate'] ?>" 
                                           min="<?= $settings['min_bet'] / $settings['currency_rate'] ?>" 
                                           max="<?= $settings['max_bet'] / $settings['currency_rate'] ?>" 
                                           step="<?= $settings['currency_rate'] ?>">
                                    <button type="button" id="half" class="btn btn-dark border-start border-white border-opacity-10 px-3">/2</button>
                                    <button type="button" id="double" class="btn btn-dark border-start border-white border-opacity-10 px-3">x2</button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Visual Feedback Column -->
                    <div class="col-lg-6 d-flex flex-column justify-content-between">
                        <div id="result" class="mb-4">
                            <div class="alert alert-info border-0 bg-info bg-opacity-10 text-info text-center p-3 rounded-4">
                                <i class="fas fa-info-circle me-2"></i> Ready to roll!
                            </div>
                        </div>

                        <div class="roll-display-box py-5 rounded-4 bg-white bg-opacity-5 border border-white border-opacity-5 text-center mb-4 position-relative">
                            <span class="text-secondary smaller text-uppercase position-absolute top-0 start-50 translate-middle-x mt-3">Current Roll</span>
                            <div id="rollNumber" class="display-1 fw-bold text-white odometer">00.00</div>
                        </div>

                        <div class="row g-3">
                            <div class="col-6">
                                <button type="button" id="rollLo" class="btn btn-primary-custom w-100 py-3 rounded-pill">
                                    <i class="fas fa-caret-down me-2"></i> ROLL LO
                                </button>
                            </div>
                            <div class="col-6">
                                <button type="button" id="rollHi" class="btn btn-secondary w-100 py-3 rounded-pill bg-white bg-opacity-10 text-white border-white border-opacity-10 hover-lift">
                                    <i class="fas fa-caret-up me-2"></i> ROLL HI
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="mt-5 pt-4 border-top border-white border-opacity-5 text-center">
                    <p class="text-secondary smaller mb-0">Next Roll Hash: <span class="text-white font-monospace opacity-75" id="hashRoll"><?= $proof ?></span></p>
                </div>
            </form>
        </div>
    </div>

    <!-- History Card -->
    <div class="col-lg-12">
        <div class="dashboard-card p-4">
            <h5 class="text-white mb-4"><i class="fas fa-history text-primary me-2"></i> Recent Game History</h5>
            <div class="table-responsive">
                <table class="table table-dark table-hover border-white border-opacity-5 text-center">
                    <thead class="bg-white bg-opacity-5">
                        <tr class="text-secondary small text-uppercase">
                            <th class="border-0">Game ID</th>
                            <th class="border-0">Secret / Target</th>
                            <th class="border-0">Bet</th>
                            <th class="border-0">Roll Result</th>
                            <th class="border-0 text-end">Profit</th>
                        </tr>
                    </thead>
                    <tbody id="diceHistory" class="text-white border-0">
                        <?php foreach ($history as $dice): 
                            $target = ($dice['type'] == 1 ? '< ' : '> ') . $dice['target'];
                            $isWin = $dice['profit'] > 0;
                        ?>
                            <tr class="transition">
                                <td class="border-0 py-3 font-monospace small">#<?= $dice["id"] ?></td>
                                <td class="border-0 py-3">
                                    <span class="smaller text-secondary d-block"><?= $dice["salt"] ?></span>
                                    <span class="badge bg-white bg-opacity-5 text-white mt-1 border border-white border-opacity-10"><?= $target ?></span>
                                </td>
                                <td class="border-0 py-3 fw-bold"><?= currencyDisplay($dice['bet'], $settings) ?></td>
                                <td class="border-0 py-3 fw-bold <?= $isWin ? 'text-success' : 'text-danger' ?>"><?= $dice['roll'] ?></td>
                                <td class="border-0 py-3 text-end fw-bold <?= $isWin ? 'text-success' : 'text-danger' ?>">
                                    <?= ($isWin ? '+' : '') . currencyDisplay($dice['profit'], $settings) ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Provably Fair Verification -->
    <div class="col-lg-12">
        <div class="dashboard-card p-4 p-md-5">
            <h4 class="text-white mb-4"><i class="fas fa-shield-alt text-info me-2"></i> Provably Fair Verification</h4>
            
            <div class="row g-5">
                <div class="col-lg-6">
                    <form action="<?= site_url('dice/verify') ?>" method="POST" autocomplete="off" class="bg-white bg-opacity-5 p-4 rounded-4 border border-white border-opacity-5">
                        <input type="hidden" name="<?= $csrf_name ?>" value="<?= $csrf_hash ?>">
                        
                        <div class="mb-3">
                            <label class="text-secondary smaller fw-bold mb-2 d-block">Secret</label>
                            <input type="text" name="secret" class="form-control border-0 bg-white bg-opacity-5 text-white p-3 small" id="secret" placeholder="Paste game secret">
                        </div>
                        
                        <div class="mb-4">
                            <label class="text-secondary smaller fw-bold mb-2 d-block">Result Roll</label>
                            <input type="text" name="roll" class="form-control border-0 bg-white bg-opacity-5 text-white p-3 small" id="roll" placeholder="Paste result roll">
                        </div>

                        <button type="submit" class="btn-primary-custom w-100 py-3 rounded-pill shadow-lg">
                            Verify Authenticity
                        </button>
                        
                        <?php if (isset($_SESSION['message'])) echo '<div class="mt-3">' . $_SESSION['message'] . '</div>'; ?>
                    </form>
                </div>
                
                <div class="col-lg-6">
                    <div class="verification-info p-2">
                        <p class="text-secondary small">This tool allows you to verify that our system didn't change the roll outcome after you placed your bet.</p>
                        <p class="text-white small fw-bold mb-2">How it works:</p>
                        <ul class="text-secondary smaller">
                            <li class="mb-2">Before each roll, an encrypted <strong>SHA1 Hash</strong> is displayed. This is the pre-calculated outcome.</li>
                            <li>After the game, the <strong>Secret</strong> is revealed in your history.</li>
                            <li>Combine <code>[secret] + [roll]</code> to generate a hash. It MUST match the pre-roll hash.</li>
                        </ul>
                        <div class="p-3 bg-black bg-opacity-20 rounded-3 font-monospace smaller text-info">
                            [secret] + [roll] = SHA1_HASH
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="<?= base_url() ?>assets/js/vie/odometer.js"></script>

<style>
    .odometer { font-family: 'JetBrains Mono', monospace; }
    .smaller { font-size: 0.75rem; }
    .italic { font-style: italic; }
    .balance-display { box-shadow: 0 4px 15px rgba(0,0,0,0.2); }
    .btn-secondary:hover { background: rgba(255,255,255,0.15) !important; color: white; }
    .roll-display-box { box-shadow: inset 0 0 40px rgba(0,0,0,0.5), 0 0 20px rgba(157, 78, 221, 0.1); }
</style>