<?php if ($settings['dashboard_top_ad']) { ?>
    <div class="ads mb-4 text-center">
        <?= $settings['dashboard_top_ad'] ?>
    </div>
<?php } ?>

<div class="row g-4 justify-content-center">
    <!-- Notice Bar -->
    <div class="col-12">
        <div class="alert alert-danger border-0 bg-danger bg-opacity-10 text-danger p-3 rounded-4 mb-4 d-flex align-items-center gap-3">
            <i class="fas fa-exclamation-circle fa-lg"></i>
            <p class="mb-0 small fw-bold">Spamming the deposit form will lead to <span class="text-white">immediate suspension</span> of your account!</p>
        </div>
    </div>

    <?php if ($settings['coinbase_deposit_status'] == 'on' || $settings['payeer_status'] == 'on' || $settings['faucetpay_deposit_status'] == 'on' || $settings['ccpayment_deposit_status'] == 'on') { ?>
        <!-- Deposit Form -->
        <div class="col-lg-6">
            <div class="dashboard-card p-4 p-md-5 h-100">
                <div class="d-flex align-items-center gap-3 mb-4 text-start">
                    <div class="feature-icon small bg-primary bg-opacity-10">
                        <i class="fas fa-plus-circle text-gradient"></i>
                    </div>
                    <div>
                        <h3 class="text-white mb-0">Deposit</h3>
                        <p class="text-secondary small mb-0">Add funds to your advertising balance.</p>
                    </div>
                </div>

                <?php if (isset($_SESSION['message'])) echo $_SESSION['message']; ?>
                <?php if (isset($message)) echo $message; ?>

                <form action="" id="depForm" method="POST" autocomplete="off" class="text-start">
                    <input type="hidden" name="<?= $csrf_name ?>" value="<?= $csrf_hash ?>">

                    <!-- Amount Input -->
                    <div class="mb-4">
                        <label class="text-white small text-uppercase tracking-wider fw-bold mb-3 d-block">1. Enter Amount (USD)</label>
                        <div class="row g-3">
                            <div class="col-sm-6">
                                <div class="input-group">
                                    <span class="input-group-text border-0 bg-white bg-opacity-5 text-secondary px-3">$</span>
                                    <input type="number" name="amount" id="usd" class="form-control border-0 bg-white bg-opacity-5 text-white p-3" 
                                           min="<?= $settings['coinbase_min_deposit'] ?>" step="0.000001" placeholder="0.00">
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="input-group">
                                    <input type="text" id="token" class="form-control border-0 bg-white bg-opacity-10 text-white p-3" disabled placeholder="0.00">
                                    <span class="input-group-text border-0 bg-white bg-opacity-10 text-primary small fw-bold px-3">Coinz</span>
                                </div>
                            </div>
                        </div>
                        <small id="minDep" class="text-warning mt-2 d-block"></small>
                    </div>

                    <!-- Method Selection -->
                    <div class="mb-4">
                        <label class="text-white small text-uppercase tracking-wider fw-bold mb-3 d-block">2. Choose Method</label>
                        <select class="form-select border-0 bg-white bg-opacity-5 text-white p-3 rounded-4" name="method" id="method">
                            <?php if ($settings['faucetpay_deposit_status'] == 'on') echo '<option value="faucetpay">FaucetPay</option>'; ?>
                            <?php if ($settings['payeer_status'] == 'on') echo '<option value="payeer">Payeer</option>'; ?>
                            <?php if ($settings['coinbase_deposit_status'] == 'on') echo '<option value="coinbase">Coinbase</option>'; ?>
                            <?php if ($settings['ccpayment_deposit_status'] == 'on') echo '<option value="ccpayment">CCPayment</option>'; ?>
                        </select>
                    </div>

                    <!-- FaucetPay Currency (Conditional) -->
                    <?php if ($settings['faucetpay_deposit_status'] == 'on') { ?>
                        <div id="fpCurrency" class="mb-4" style="<?= ($settings['faucetpay_currency'] == '') ? 'display:none;' : '' ?>">
                            <label class="text-white small text-uppercase tracking-wider fw-bold mb-3 d-block">3. Select Coin</label>
                            <?php if ($settings['faucetpay_currency'] == '') { ?>
                                <input type="hidden" name="currency2" value="<?= $settings['faucetpay_currency'] ?>">
                            <?php } else { ?>
                                <select class="form-select border-0 bg-white bg-opacity-5 text-white p-3 rounded-4" name="currency2">
                                    <?php foreach ($faucetpayMethods as $method) { ?>
                                        <option value="<?= $method ?>"><?= $method ?></option>
                                    <?php } ?>
                                </select>
                            <?php } ?>
                            <input type="hidden" name="merchant_username" value="<?= $settings['faucetpay_username'] ?>">
                            <input type="hidden" name="item_description" value="Deposit to <?= $settings['name'] ?>">
                            <input type="hidden" name="currency1" value="USDT">
                            <input type="hidden" name="amount1" value="1">
                            <input type="hidden" name="custom" value="<?= $user['id'] ?>">
                            <input type="hidden" name="callback_url" value="<?= site_url('wh/faucetpay') ?>">
                            <input type="hidden" name="success_url" value="<?= site_url('deposit?success=true') ?>">
                            <input type="hidden" name="cancel_url" value="<?= site_url('deposit?success=false') ?>">
                        </div>
                    <?php } ?>

                    <button type="submit" class="btn-primary-custom w-100 py-3 rounded-pill">
                        <i class="fas fa-wallet me-2"></i> Proceed to Payment
                    </button>
                </form>
            </div>
        </div>
    <?php } ?>

    <!-- History Table -->
    <div class="col-lg-12">
        <div class="dashboard-card p-4">
            <h4 class="text-white text-start mb-4"><i class="fas fa-history text-secondary me-2"></i> Deposit History</h4>
            <div class="table-responsive">
                <table class="table table-dark table-hover border-white border-opacity-5 mb-0">
                    <thead>
                        <tr class="text-secondary small text-uppercase tracking-tighter">
                            <th class="border-0 bg-white bg-opacity-5">Method/Code</th>
                            <th class="border-0 bg-white bg-opacity-5">Status</th>
                            <th class="border-0 bg-white bg-opacity-5">Amount</th>
                            <th class="border-0 bg-white bg-opacity-5 text-end">Date</th>
                        </tr>
                    </thead>
                    <tbody class="text-white border-0">
                        <?php if (empty($deposits)): ?>
                            <tr>
                                <td colspan="4" class="text-center py-5 text-secondary border-0 italic">No deposit history found.</td>
                            </tr>
                        <?php else: ?>
                            <?php foreach ($deposits as $deposit): ?>
                                <tr class="transition">
                                    <td class="border-0 py-3">
                                        <?php if ($deposit['type'] == 1): ?>
                                            <span class="text-info fw-bold">FaucetPay:</span> <span class="small opacity-75"><?= $deposit["code"] ?></span>
                                        <?php elseif ($deposit['type'] == 2): ?>
                                            <span class="text-primary fw-bold">Coinbase:</span> <a href="https://commerce.coinbase.com/charges/<?= $deposit["code"] ?>" target="_blank" class="text-decoration-none small text-white opacity-75"><?= $deposit["code"] ?></a>
                                        <?php elseif ($deposit['type'] == 3): ?>
                                            <span class="text-warning fw-bold">Payeer:</span> <span class="small opacity-75"><?= $deposit["code"] ?></span>
                                        <?php else: ?>
                                            <span class="text-gradient fw-bold">CCPayment:</span> <span class="small opacity-75"><?= $deposit["code"] ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="border-0 py-3">
                                        <span class="badge rounded-pill bg-opacity-10 <?= ($deposit['status'] == 'completed' || $deposit['status'] == 'confirmed') ? 'bg-success text-success' : 'bg-warning text-warning' ?> px-3 py-2 small">
                                            <?= ucfirst($deposit["status"]) ?>
                                        </span>
                                    </td>
                                    <td class="border-0 py-3 fw-bold">
                                        <?= currencyDisplay($deposit["amount"], $settings) ?>
                                    </td>
                                    <td class="border-0 py-3 text-end text-secondary small">
                                        <?= timespan($deposit["create_time"], time(), 1) ?> ago
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<style>
    .table-hover tbody tr:hover {
        background: rgba(255, 255, 255, 0.02) !important;
    }
    .form-select {
        background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%23ffffff' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='m2 5 6 6 6-6'/%3e%3c/svg%3e");
    }
    .form-select option {
        background: #1a1a25;
        color: white;
    }
</style>

<script>
    var rate = <?= $settings['currency_rate'] ?>;
    var methods = {
        faucetpay: {
            url: 'https://faucetpay.io/merchant/webscr',
            min: <?= $settings['faucetpay_min_deposit'] ?>
        },
        coinbase: {
            url: '<?= site_url('/deposit/coinbase') ?>',
            min: <?= $settings['coinbase_min_deposit'] ?>
        },
        payeer: {
            url: '<?= site_url('/deposit/payeer') ?>',
            min: <?= $settings['payeer_min_deposit'] ?>
        },
        ccpayment: {
            url: '<?= site_url('/deposit/ccpayment') ?>',
            min: <?= $settings['ccpayment_minimum_deposit'] ?>
        },
    }

    document.getElementById('usd')?.addEventListener('input', function() {
        document.getElementById('token').value = (this.value * rate).toFixed(2);
    });

    document.getElementById('method')?.addEventListener('change', function() {
        const selected = this.value;
        const minDep = methods[selected].min;
        document.getElementById('depForm').action = methods[selected].url;
        document.getElementById('usd').min = minDep;
        document.getElementById('minDep').textContent = 'Minimum deposit for ' + selected + ' is $' + minDep;
        
        const fpDiv = document.getElementById('fpCurrency');
        if (fpDiv) {
            fpDiv.style.display = (selected === 'faucetpay') ? 'block' : 'none';
        }
    });
    
    // Trigger initial state
    document.getElementById('method')?.dispatchEvent(new Event('change'));
</script>