<?php if ($settings['dashboard_top_ad']) { ?>
    <div class="ads mb-4 text-center">
        <?= $settings['dashboard_top_ad'] ?>
    </div>
<?php } ?>

<div class="row g-4 justify-content-center">
    <!-- Header/Countdown -->
    <div class="col-12">
        <div class="dashboard-card p-4 text-center border-info border-opacity-20" style="background: linear-gradient(135deg, rgba(13, 110, 253, 0.1), rgba(var(--bg-card-rgb), 1));">
            <div class="d-flex flex-column align-items-center">
                <div class="feature-icon small bg-info bg-opacity-10 mb-3">
                    <i class="fas fa-trophy text-info pulse"></i>
                </div>
                <h3 class="text-white mb-2 fw-bold">Active Referral Contest</h3>
                <p class="text-secondary small mb-3">Ends in <span class="text-white fw-bold"><?= timespan(time(), $leaderboardSettings["contest_date"], 2) ?></span></p>
                <div class="badge rounded-pill bg-white bg-opacity-5 text-secondary border border-white border-opacity-10 px-3 py-2 small">
                    <i class="fas fa-sync-alt me-1 opacity-50"></i> Information updates every 10 minutes
                </div>
            </div>
        </div>
    </div>

    <!-- Rules & Strategy -->
    <div class="col-lg-6">
        <div class="dashboard-card p-4 h-100">
            <h5 class="text-white mb-4"><i class="fas fa-scroll text-warning me-2"></i> Terms & Conditions</h5>
            <div class="rules-list text-secondary small">
                <div class="rule-item d-flex gap-3 mb-3">
                    <div class="rule-num text-warning fw-bold">01</div>
                    <p class="mb-0">You must have <strong>20 or more</strong> 1st level referrals registered during the contest period to be eligible for prizes.</p>
                </div>
                <div class="rule-item d-flex gap-3 mb-3">
                    <div class="rule-num text-warning fw-bold">02</div>
                    <p class="mb-0">Total income of referrals invited during the contest must be at least <strong>1,000 coinz</strong>.</p>
                </div>
                <div class="rule-item d-flex gap-3 mb-3">
                    <div class="rule-num text-warning fw-bold">03</div>
                    <p class="mb-0">Fraudulent activities or unnatural manipulation of statistics will result in immediate disqualification.</p>
                </div>
                <div class="rule-item d-flex gap-3">
                    <div class="rule-num text-warning fw-bold">04</div>
                    <p class="mb-0">Prizes are only awarded if all conditions are met. Ranks with unmet conditions will not receive rewards.</p>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-6">
        <div class="dashboard-card p-4 h-100">
            <h5 class="text-white mb-4"><i class="fas fa-lightbulb text-info me-2"></i> How to Get Referrals?</h5>
            <div class="promotion-tips">
                <p class="text-secondary small mb-3">The best way to win is to promote your link across multiple platforms:</p>
                
                <div class="tip-section mb-4">
                    <h6 class="text-white smaller text-uppercase tracking-wider mb-2">Free Promotion</h6>
                    <p class="text-secondary smaller">Share on Facebook, Twitter, Instagram, TikTok, Beermoneyforum, or YouTube reviews.</p>
                </div>

                <div class="tip-section mb-3">
                    <h6 class="text-white smaller text-uppercase tracking-wider mb-2">PTC Advertising (Recommended)</h6>
                    <div class="d-flex flex-wrap gap-2">
                        <?php 
                        $sites = [
                            'Vie Faucet' => 'https://viefaucet.com?r=629aa19c202496884151cb33',
                            'Earn Pepe' => 'https://earn-pepe.com/?r=115203',
                            'BitHub' => 'https://bithub.win/?r=26728',
                            'CryptoFlare' => 'https://cryptoflare.net/?r=48829',
                            'Fire Faucet' => 'https://firefaucet.win/ref/Merox',
                            'CoinPayu' => 'https://www.coinpayu.com/?r=Merox'
                        ];
                        foreach($sites as $name => $url): ?>
                            <a href="<?= $url ?>" target="_blank" class="badge rounded-pill bg-white bg-opacity-5 text-info text-decoration-none border border-white border-opacity-10 px-3 py-2 transition hover-lift-sm">
                                <?= $name ?> <i class="fas fa-external-link-alt ms-1 smaller opacity-50"></i>
                            </a>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Leaderboard -->
    <div class="col-12 mt-4">
        <div class="dashboard-card p-4 p-md-5">
            <div class="d-flex flex-column align-items-center mb-5">
                <h2 class="text-white mb-2">Referral Contest Leaderboard</h2>
                <div class="d-flex gap-4 text-secondary small fw-bold">
                    <span>Your Referrals: <span class="text-white"><?= $user['ref_count'] ?></span></span>
                    <span class="opacity-25">|</span>
                    <span>Referral Amount: <span class="text-white"><?= currencyDisplay($user['ref_count_tmp'], $settings) ?></span></span>
                </div>
            </div>

            <?php if ($leaderboardSettings['referral_contest_reward'] != ""): 
                $rewards = explode('|', $leaderboardSettings['referral_contest_reward']);
            ?>
                <div class="table-responsive">
                    <table class="table table-dark table-hover border-white border-opacity-5 text-center">
                        <thead class="bg-white bg-opacity-5">
                            <tr class="text-secondary small text-uppercase">
                                <th class="border-0">Rank</th>
                                <th class="border-0 text-start">Username</th>
                                <th class="border-0">Referrals</th>
                                <th class="border-0">Amount</th>
                                <th class="border-0 text-end">Prize Pool</th>
                            </tr>
                        </thead>
                        <tbody class="text-white border-0">
                            <?php
                            $rank = 0;
                            foreach ($topReferral as $u):
                                $reward = $rank < count($rewards) ? $rewards[$rank] : 0;
                                $isTop3 = $rank < 3;
                            ?>
                                <tr class="transition">
                                    <td class="border-0 py-4">
                                        <?php if ($rank == 0) echo '<i class="fas fa-crown text-warning fa-lg"></i>'; 
                                              elseif ($rank == 1) echo '<i class="fas fa-medal text-secondary fa-lg"></i>';
                                              elseif ($rank == 2) echo '<i class="fas fa-medal text-bronze fa-lg"></i>';
                                              else echo '#' . ($rank + 1); ?>
                                    </td>
                                    <td class="border-0 py-4 text-start fw-bold">
                                        <div class="d-flex align-items-center gap-2">
                                            <span><?= $u["username"] ?></span>
                                            <?php if ($u['username'] == $user['username']) echo '<span class="badge bg-primary bg-opacity-10 text-primary border border-primary border-opacity-10 smaller px-2 py-1">YOU</span>'; ?>
                                        </div>
                                    </td>
                                    <td class="border-0 py-4"><?= $u["ref_count"] ?></td>
                                    <td class="border-0 py-4"><?= currencyDisplay($u["ref_count_tmp"], $settings) ?></td>
                                    <td class="border-0 py-4 text-end fw-bold text-gradient">
                                        <?= currencyDisplay($reward, $settings) ?>
                                    </td>
                                </tr>
                                <?php $rank++; ?>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<style>
    .smaller { font-size: 0.7rem; }
    .text-bronze { color: #cd7f32; }
    .pulse { animation: contest-pulse 2s infinite ease-in-out; }
    @keyframes contest-pulse {
        0%, 100% { transform: scale(1); filter: drop-shadow(0 0 0px var(--info)); }
        50% { transform: scale(1.1); filter: drop-shadow(0 0 10px rgba(13, 110, 253, 0.5)); }
    }
    .hover-lift-sm:hover { transform: translateY(-3px); background: rgba(var(--primary-rgb), 0.1) !important; color: white !important; }
</style>