<?php if ($settings['ptc_top_ad']) { ?>
    <div class="ads mb-4 text-center">
        <?= $settings['ptc_top_ad'] ?>
    </div>
<?php } ?>

<div class="row g-4">
    <div class="col-12">
        <div class="dashboard-card p-4 p-md-5">
            <div class="d-flex align-items-center gap-3 mb-5">
                <div class="feature-icon small bg-primary bg-opacity-10">
                    <i class="fas fa-tasks text-gradient"></i>
                </div>
                <div>
                    <h2 class="text-white mb-0">Manage Campaigns</h2>
                    <p class="text-secondary small mb-0">Track performance and manage views for your active advertisements.</p>
                </div>
            </div>

            <?php if (isset($_SESSION['message'])) echo '<div class="mb-4 text-start">' . $_SESSION['message'] . '</div>'; ?>

            <div class="table-responsive">
                <table class="table table-dark table-hover border-white border-opacity-5 align-middle">
                    <thead class="bg-white bg-opacity-5">
                        <tr class="text-secondary small text-uppercase">
                            <th class="border-0">Campaign Details</th>
                            <th class="border-0 text-center">Settings</th>
                            <th class="border-0 text-center">Progress</th>
                            <th class="border-0 text-center">Status</th>
                            <th class="border-0 text-end">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="text-white border-0">
                        <?php if (empty($ads)): ?>
                            <tr><td colspan="5" class="text-center py-5 text-secondary italic border-0">You haven't created any campaigns yet.</td></tr>
                        <?php else: ?>
                            <?php foreach ($ads as $ad): 
                                $progress = ($ad['total_view'] > 0) ? min(100, ($ad['views'] / $ad['total_view']) * 100) : 0;
                            ?>
                                <tr class="transition">
                                    <td class="border-0 py-4">
                                        <div class="d-flex flex-column">
                                            <span class="fw-bold text-white mb-1"><?= $ad["name"] ?></span>
                                            <span class="text-secondary smaller text-truncate" style="max-width: 250px;"><?= $ad["description"] ?></span>
                                            <a href="<?= $ad['url'] ?>" target="_blank" class="text-primary smaller mt-1 d-inline-block text-decoration-none"><i class="fas fa-external-link-alt me-1"></i> View Site</a>
                                        </div>
                                    </td>
                                    <td class="border-0 py-4 text-center">
                                        <div class="d-flex flex-column gap-1">
                                            <span class="badge bg-white bg-opacity-5 text-secondary border border-white border-opacity-10"><?= $ad["timer"] ?>s Timer</span>
                                            <span class="badge bg-white bg-opacity-5 text-secondary border border-white border-opacity-10"><?= currencyDisplay($ad["price"], $settings) ?>/view</span>
                                        </div>
                                    </td>
                                    <td class="border-0 py-4">
                                        <div class="text-center mb-1">
                                            <span class="text-white small fw-bold"><?= $ad["views"] ?> / <?= $ad["total_view"] ?></span>
                                        </div>
                                        <div class="progress rounded-pill bg-white bg-opacity-5 mx-auto" style="height: 6px; max-width: 150px;">
                                            <div class="progress-bar bg-info rounded-pill" role="progressbar" style="width: <?= $progress ?>%"></div>
                                        </div>
                                    </td>
                                    <td class="border-0 py-4 text-center">
                                        <?php if ($ad['status'] == 'active'): ?>
                                            <span class="badge rounded-pill bg-success bg-opacity-10 text-success px-3 py-2 border border-success border-opacity-25">Active</span>
                                        <?php elseif ($ad['status'] == 'paused'): ?>
                                            <span class="badge rounded-pill bg-warning bg-opacity-10 text-warning px-3 py-2 border border-warning border-opacity-25">Paused</span>
                                        <?php else: ?>
                                            <span class="badge rounded-pill bg-secondary bg-opacity-10 text-secondary px-3 py-2 border border-white border-opacity-10"><?= ucfirst($ad['status']) ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="border-0 py-4 text-end">
                                        <div class="d-flex justify-content-end gap-2">
                                            <?php if ($ad['status'] == 'paused'): ?>
                                                <a href="<?= site_url("advertise/start/" . $ad['id']) ?>" class="btn btn-sm btn-outline-success rounded-pill px-3" title="Resume"><i class="fas fa-play"></i></a>
                                            <?php else: ?>
                                                <a href="<?= site_url("advertise/pause/" . $ad['id']) ?>" class="btn btn-sm btn-outline-warning rounded-pill px-3" title="Pause"><i class="fas fa-pause"></i></a>
                                            <?php endif; ?>
                                            
                                            <button type="button" class="btn btn-sm btn-outline-info rounded-pill px-3" data-bs-toggle="modal" data-bs-target="#add-<?= $ad['id'] ?>" title="Add Views"><i class="fas fa-plus"></i></button>
                                            <a href="<?= site_url("advertise/delete/" . $ad['id']) ?>" class="btn btn-sm btn-outline-danger rounded-pill px-3" onclick="return confirm('Are you sure you want to delete this campaign?')" title="Delete"><i class="fas fa-trash"></i></a>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php foreach ($ads as $ad): ?>
    <!-- Add Views Modal -->
    <div class="modal fade" id="add-<?= $ad['id'] ?>" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content border-white border-opacity-10" style="background: rgba(20, 20, 30, 0.95); backdrop-filter: blur(20px);">
                <div class="modal-header border-white border-opacity-5 p-4">
                    <h5 class="modal-title text-white fw-bold"><i class="fas fa-plus-circle text-info me-2"></i>Add Views to Campaign</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body p-4 text-start">
                    <form action="<?= site_url('advertise/add_view/'.$ad['id']) ?>" method="POST" autocomplete="off">
                        <input type="hidden" name="<?= $csrf_name ?>" value="<?= $csrf_hash ?>">
                        
                        <div class="mb-4 text-center">
                            <p class="text-secondary small mb-2">Campaign: <span class="text-white fw-bold"><?= $ad['name'] ?></span></p>
                            <p class="text-secondary small">Cost per view: <span class="text-info fw-bold"><?= currencyDisplay($ad['price'], $settings) ?></span></p>
                        </div>

                        <div class="mb-4">
                            <label class="text-secondary smaller fw-bold mb-2 d-block">Number of Views</label>
                            <div class="input-group">
                                <span class="input-group-text border-0 bg-white bg-opacity-5 text-secondary px-3"><i class="fas fa-eye small"></i></span>
                                <input type="number" name="view" class="form-control border-0 bg-white bg-opacity-5 text-white p-3" 
                                       min="1" max="<?= floor($user['dep_balance'] / $ad['price']) ?>" required>
                            </div>
                            <div class="d-flex justify-content-between mt-2">
                                <small class="text-secondary italic">Max possible: <?= floor($user['dep_balance'] / $ad['price']) ?></small>
                                <small class="text-secondary">Deposit: <?= format_money($user['dep_balance']) ?></small>
                            </div>
                        </div>

                        <button type="submit" class="btn-primary-custom w-100 py-3 rounded-pill shadow-lg">
                            <i class="fas fa-plus me-1"></i> Purchase Views
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php endforeach; ?>

<style>
    .smaller { font-size: 0.75rem; }
    .italic { font-style: italic; }
    .btn-outline-success:hover { background-color: rgba(40, 167, 69, 0.1); color: #28a745; border-color: #28a745; }
    .btn-outline-warning:hover { background-color: rgba(255, 193, 7, 0.1); color: #ffc107; border-color: #ffc107; }
    .btn-outline-info:hover { background-color: rgba(23, 162, 184, 0.1); color: #17a2b8; border-color: #17a2b8; }
    .btn-outline-danger:hover { background-color: rgba(220, 53, 69, 0.1); color: #dc3545; border-color: #dc3545; }
</style>