<?php if ($settings['ptc_top_ad']) { ?>
    <div class="ads mb-4 text-center">
        <?= $settings['ptc_top_ad'] ?>
    </div>
<?php } ?>

<div class="row g-4 justify-content-center">
    <!-- Balance Notice -->
    <div class="col-lg-10">
        <div class="alert alert-info border-0 bg-info bg-opacity-10 text-info p-4 rounded-4 mb-2 d-flex align-items-center gap-3">
            <div class="feature-icon small bg-info bg-opacity-20 flex-shrink-0">
                <i class="fas fa-wallet"></i>
            </div>
            <div>
                <p class="mb-0 fw-bold">Active Deposit Balance: <span class="text-white"><?= format_money($user['dep_balance']) ?></span></p>
                <p class="mb-0 small opacity-75">You can <a href="<?= site_url('deposit') ?>" class="text-info fw-bold">Deposit</a> new funds or <a href="<?= site_url('transfer') ?>" class="text-info fw-bold">Transfer</a> from Main Balance to start your campaign.</p>
            </div>
        </div>
    </div>

    <div class="col-lg-10">
        <div class="dashboard-card p-4 p-md-5">
            <div class="d-flex align-items-center gap-3 mb-5">
                <div class="feature-icon small bg-primary bg-opacity-10">
                    <i class="fas fa-bullhorn text-gradient"></i>
                </div>
                <div>
                    <h2 class="text-white mb-0">Create PTC Campaign</h2>
                    <p class="text-secondary small mb-0">Promote your website or referral link to thousands of active users.</p>
                </div>
            </div>

            <?php if (isset($_SESSION['message'])) echo '<div class="mb-4">' . $_SESSION['message'] . '</div>'; ?>

            <form action="<?= site_url('/advertise/add') ?>" method="POST" class="text-start">
                <input type="hidden" name="<?= $csrf_name ?>" id="token" value="<?= $csrf_hash ?>">

                <div class="row g-4">
                    <div class="col-md-6">
                        <label class="text-secondary small text-uppercase fw-bold mb-2 d-block">Campaign Name</label>
                        <div class="input-group">
                            <span class="input-group-text border-0 bg-white bg-opacity-5 text-secondary px-3"><i class="fas fa-globe small"></i></span>
                            <input type="text" name="name" class="form-control border-0 bg-white bg-opacity-5 text-white p-3" placeholder="e.g. My Awesome Site" minlength="1" maxlength="75" required>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <label class="text-secondary small text-uppercase fw-bold mb-2 d-block">Short Description</label>
                        <div class="input-group">
                            <span class="input-group-text border-0 bg-white bg-opacity-5 text-secondary px-3"><i class="fas fa-comment-dots small"></i></span>
                            <input type="text" name="description" class="form-control border-0 bg-white bg-opacity-5 text-white p-3" placeholder="Briefly describe what you're promoting" minlength="1" maxlength="75" required>
                        </div>
                    </div>

                    <div class="col-12">
                        <label class="text-secondary small text-uppercase fw-bold mb-2 d-block">Website URL</label>
                        <div class="input-group">
                            <span class="input-group-text border-0 bg-white bg-opacity-5 text-secondary px-3"><i class="fas fa-link small"></i></span>
                            <input type="url" name="url" class="form-control border-0 bg-white bg-opacity-5 text-white p-3" placeholder="https://example.com" required>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <label class="text-secondary small text-uppercase fw-bold mb-2 d-block">Total Views</label>
                        <div class="input-group">
                            <span class="input-group-text border-0 bg-white bg-opacity-5 text-secondary px-3"><i class="fas fa-eye small"></i></span>
                            <input type="number" name="view" class="form-control border-0 bg-white bg-opacity-5 text-white p-3" min="1" placeholder="100" required>
                        </div>
                    </div>

                    <div class="col-md-8">
                        <label class="text-secondary small text-uppercase fw-bold mb-2 d-block">Select Duration & Price</label>
                        <div class="input-group">
                            <span class="input-group-text border-0 bg-white bg-opacity-5 text-secondary px-3"><i class="fas fa-stopwatch small"></i></span>
                            <select class="form-select border-0 bg-white bg-opacity-5 text-white p-3" name="option" style="background-image: none;">
                                <?php foreach ($options as $option): ?>
                                    <option value="<?= $option['id'] ?>" class="bg-dark"><?= $option['timer'] ?> seconds (<?= currencyDisplay($option['price'], $settings) ?>/view, min <?= $option['min_view'] ?> views)</option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>

                    <?php if ($settings['coupon_status'] == 'on'): ?>
                        <div class="col-12">
                            <label class="text-secondary small text-uppercase fw-bold mb-2 d-block">Promotional Coupon (Optional)</label>
                            <div class="input-group">
                                <span class="input-group-text border-0 bg-white bg-opacity-5 text-secondary px-3"><i class="fas fa-ticket-alt small"></i></span>
                                <input type="text" id="coupon-code" name="code" class="form-control border-0 bg-white bg-opacity-5 text-white p-3" placeholder="Enter coupon code">
                                <button class="btn btn-primary px-4" id="coupon-check" type="button">Check</button>
                            </div>
                            <div id="coupon-result" class="mt-2 small"></div>
                        </div>
                    <?php endif; ?>

                    <div class="col-12 mt-4">
                        <button type="submit" class="btn-primary-custom w-100 py-3 rounded-pill shadow-lg">
                            <i class="fas fa-rocket me-2"></i> Launch My Campaign
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<style>
    .form-select option {
        padding: 10px;
    }
    .input-group-text i { font-size: 0.9rem; }
    .btn-primary-custom { padding: 15px !important; }
</style>