<?php if ($settings['achievements_top_ad']) { ?>
    <div class="ads mb-4 text-center">
        <?= $settings['achievements_top_ad'] ?>
    </div>
<?php } ?>

<div class="row g-4">
    <!-- Status Notice -->
    <div class="col-12 text-start">
        <div class="alert alert-info border-0 bg-info bg-opacity-10 text-info p-3 rounded-4 mb-2 d-flex align-items-center gap-3">
            <i class="fas fa-sync-alt fa-spin"></i>
            <p class="mb-0 small fw-bold">Achievements reset automatically at <span class="text-white">00:00 UTC</span> every day. Complete them daily for maximum rewards!</p>
        </div>
    </div>

    <div class="col-12">
        <div class="dashboard-card p-4">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h4 class="text-white mb-0"><i class="fas fa-trophy text-warning me-2"></i> Daily Milestones</h4>
                <span class="badge bg-white bg-opacity-10 text-secondary small px-3 py-2 rounded-pill border border-white border-opacity-5">Reset is local to UTC</span>
            </div>

            <?php if (isset($_SESSION['message'])) echo $_SESSION['message']; ?>

            <div class="achievement-list grid gap-3">
                <?php foreach ($achievements as $achievement): 
                    $isCompleted = ($achievement['completed'] >= $achievement['condition']);
                    $progressPct = min(100, $achievement['progress']);
                ?>
                    <div class="achievement-item p-4 rounded-4 border border-white border-opacity-5 bg-white bg-opacity-5 mb-3 transition hover-lift">
                        <div class="row align-items-center">
                            <!-- Icon & Description -->
                            <div class="col-lg-5 mb-3 mb-lg-0 text-start">
                                <div class="d-flex align-items-center gap-3">
                                    <div class="feature-icon small <?= $isCompleted ? 'bg-success' : 'bg-primary' ?> bg-opacity-10 flex-shrink-0">
                                        <i class="fas <?= $isCompleted ? 'fa-check' : 'fa-star' ?> <?= $isCompleted ? 'text-success' : 'text-gradient' ?>"></i>
                                    </div>
                                    <div>
                                        <h6 class="text-white mb-1"><?= $achievement['description'] ?></h6>
                                        <div class="d-flex gap-2 mt-2">
                                            <span class="badge rounded-pill bg-warning bg-opacity-10 text-warning border border-warning border-opacity-25 small px-2 py-1">
                                                <i class="fas fa-coins me-1"></i> <?= currencyDisplay($achievement['reward_usd'], $settings) ?>
                                            </span>
                                            <span class="badge rounded-pill bg-info bg-opacity-10 text-info border border-info border-opacity-25 small px-2 py-1">
                                                <i class="fas fa-bolt me-1"></i> <?= $achievement['reward_energy'] ?> Energy
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Progress Bar -->
                            <div class="col-lg-5 mb-3 mb-lg-0">
                                <div class="d-flex justify-content-between mb-2">
                                    <span class="text-secondary smaller">Progress</span>
                                    <span class="text-white smaller fw-bold"><?= $achievement['completed'] ?> / <?= $achievement['condition'] ?></span>
                                </div>
                                <div class="progress rounded-pill bg-white bg-opacity-5" style="height: 10px;">
                                    <div class="progress-bar rounded-pill <?= $isCompleted ? 'bg-success' : 'progress-bar-striped progress-bar-animated' ?>" 
                                         role="progressbar" style="width: <?= $progressPct ?>%; <?= !$isCompleted ? 'background: var(--primary-gradient);' : '' ?>"></div>
                                </div>
                            </div>

                            <!-- Claim Button -->
                            <div class="col-lg-2 text-lg-end">
                                <form action="<?= site_url('achievements/claim/' . $achievement['id']) ?>" method="POST">
                                    <input type="hidden" name="<?= $csrf_name ?>" value="<?= $csrf_hash ?>">
                                    <button type="submit" class="btn <?= $isCompleted ? 'btn-success' : 'btn-dark opacity-50' ?> rounded-pill px-4 py-2 w-100" 
                                            <?= !$isCompleted ? 'disabled' : '' ?>>
                                        <?= $isCompleted ? '<i class="fas fa-gift me-2"></i> Claim' : 'Locked' ?>
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>

                <?php if (empty($achievements)): ?>
                    <div class="text-center py-5">
                        <i class="fas fa-layer-group fa-3x text-muted mb-3"></i>
                        <p class="text-secondary italic">No achievements available at the moment. Check back later!</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<style>
    .achievement-item:hover {
        background: rgba(255, 255, 255, 0.08);
        border-color: rgba(255, 255, 255, 0.15);
    }
    .smaller { font-size: 0.75rem; }
    .feature-icon.small {
        width: 40px;
        height: 40px;
        font-size: 1rem;
    }
</style>