<div class="row justify-content-center">
    <div class="col-lg-6">
        <div class="dashboard-card p-5 slide-up hover-lift shadow-large">
            <div class="text-center mb-5">
                <h2 class="section-title mb-2">Create <span class="text-gradient">Account</span></h2>
                <p class="text-secondary">Join us today and start earning rewards!</p>
            </div>

            <form action="<?= site_url('auth/register') ?>" method="POST">
                <input type="hidden" name="<?= $csrf_name ?>" value="<?= $csrf_hash ?>">
                
                <div class="row g-3 mb-4">
                    <div class="col-md-6">
                        <label class="form-label text-white-50 small mb-2">Username</label>
                        <div class="input-group">
                            <span class="input-group-text bg-transparent border-secondary text-secondary" style="border-right: none;"><i class="fas fa-user"></i></span>
                            <input class="form-control bg-transparent border-secondary text-white" style="border-left: none;" type="text" name="username" placeholder="Username" required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label text-white-50 small mb-2">Email Address</label>
                        <div class="input-group">
                            <span class="input-group-text bg-transparent border-secondary text-secondary" style="border-right: none;"><i class="fas fa-envelope"></i></span>
                            <input class="form-control bg-transparent border-secondary text-white" style="border-left: none;" type="email" name="email" placeholder="Email" required>
                        </div>
                    </div>
                </div>

                <div class="row g-3 mb-4">
                    <div class="col-md-6">
                        <label class="form-label text-white-50 small mb-2">Password</label>
                        <div class="input-group">
                            <span class="input-group-text bg-transparent border-secondary text-secondary" style="border-right: none;"><i class="fas fa-lock"></i></span>
                            <input class="form-control bg-transparent border-secondary text-white" style="border-left: none;" type="password" name="password" placeholder="Password" required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label text-white-50 small mb-2">Confirm Password</label>
                        <div class="input-group">
                            <span class="input-group-text bg-transparent border-secondary text-secondary" style="border-right: none;"><i class="fas fa-check-double"></i></span>
                            <input class="form-control bg-transparent border-secondary text-white" style="border-left: none;" type="password" name="confirm_password" placeholder="Confirm" required>
                        </div>
                    </div>
                </div>

                <div class="mb-4 text-center">
                    <?= $captcha_display ?>
                </div>

                <div class="mb-4">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="terms" required>
                        <label class="form-check-label text-secondary small" for="terms">
                            I agree to the <a href="<?= site_url('page/terms') ?>" class="text-gradient fw-bold text-decoration-none">Terms and Conditions</a>
                        </label>
                    </div>
                </div>

                <button class="btn-primary-custom w-100 py-3 mb-4" type="submit">
                    <i class="fas fa-user-plus me-2"></i>Create My Account
                </button>

                <div class="text-center">
                    <p class="text-secondary small">Already have an account? <a href="<?= site_url('login') ?>" class="text-white text-decoration-none fw-bold hover-lift d-inline-block">Sign In Here</a></p>
                </div>
            </form>
        </div>
    </div>
</div>

<style>
    .form-control:focus {
        background: rgba(255,255,255,0.05) !important;
        color: white;
        border-color: var(--primary) !important;
        box-shadow: 0 0 15px rgba(240, 5, 193, 0.2);
    }
    .input-group-text {
        border-radius: 12px 0 0 12px;
        transition: var(--transition);
    }
    .form-control {
        border-radius: 0 12px 12px 0;
        padding: 12px 15px;
        transition: var(--transition);
    }
    .input-group:focus-within .input-group-text {
        border-color: var(--primary) !important;
        color: var(--primary) !important;
    }
</style>
