<div class="row justify-content-center">
    <div class="col-lg-5">
        <div class="dashboard-card p-5 slide-up hover-lift shadow-large">
            <div class="text-center mb-5">
                <h2 class="section-title mb-2">Sign <span class="text-gradient">In</span></h2>
                <p class="text-secondary">Welcome back! Please login to your account.</p>
            </div>

            <form action="<?= site_url('auth/login') ?>" method="POST">
                <input type="hidden" name="<?= $csrf_name ?>" value="<?= $csrf_hash ?>">
                
                <div class="mb-4">
                    <label class="form-label text-white-50 small mb-2">Email Address</label>
                    <div class="input-group">
                        <span class="input-group-text bg-transparent border-secondary text-secondary" style="border-right: none;"><i class="fas fa-envelope"></i></span>
                        <input class="form-control bg-transparent border-secondary text-white" style="border-left: none;" type="email" name="email" id="email" placeholder="name@example.com" required>
                    </div>
                </div>

                <div class="mb-4">
                    <label class="form-label text-white-50 small mb-2">Password</label>
                    <div class="input-group">
                        <span class="input-group-text bg-transparent border-secondary text-secondary" style="border-right: none;"><i class="fas fa-lock"></i></span>
                        <input class="form-control bg-transparent border-secondary text-white" style="border-left: none;" type="password" name="password" id="password" placeholder="••••••••" required>
                    </div>
                </div>

                <div class="mb-4 text-center">
                    <?= $captcha_display ?>
                </div>

                <div class="mb-4 d-flex justify-content-between align-items-center">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="remember">
                        <label class="form-check-label text-secondary small" for="remember">Remember me</label>
                    </div>
                    <a href="<?= site_url('forgot-password') ?>" class="text-gradient small fw-bold text-decoration-none">Forgot Password?</a>
                </div>

                <button class="btn-primary-custom w-100 py-3 mb-4" type="submit">
                    <i class="fas fa-sign-in-alt me-2"></i>Sign In
                </button>

                <div class="text-center">
                    <p class="text-secondary small">Don't have an account? <a href="<?= site_url('register') ?>" class="text-white text-decoration-none fw-bold hover-lift d-inline-block">Sign Up Free</a></p>
                </div>
            </form>
        </div>
    </div>
</div>

<style>
    .form-control:focus {
        background: rgba(255,255,255,0.05) !important;
        color: white;
        border-color: var(--primary) !important;
        box-shadow: 0 0 15px rgba(240, 5, 193, 0.2);
    }
    .input-group-text {
        border-radius: 12px 0 0 12px;
        transition: var(--transition);
    }
    .form-control {
        border-radius: 0 12px 12px 0;
        padding: 12px 15px;
        transition: var(--transition);
    }
    .input-group:focus-within .input-group-text {
        border-color: var(--primary) !important;
        color: var(--primary) !important;
    }
</style>
