<div class="row justify-content-center">
    <div class="col-lg-5">
        <div class="feature-card p-5 slide-up" style="background: rgba(20, 20, 30, 0.6);">
            <div class="text-center mb-5">
                <h2 class="section-title mb-2">Reset <span class="text-gradient">Password</span></h2>
                <p class="text-secondary">Enter your email and we'll send you instructions to reset your password.</p>
            </div>

            <form action="<?= site_url('auth/forgot-password') ?>" method="POST">
                <input type="hidden" name="<?= $csrf_name ?>" value="<?= $csrf_hash ?>">
                
                <div class="mb-4">
                    <label class="form-label text-white-50 small mb-2">Email Address</label>
                    <div class="input-group">
                        <span class="input-group-text bg-transparent border-secondary text-secondary" style="border-right: none;"><i class="fas fa-envelope"></i></span>
                        <input class="form-control bg-transparent border-secondary text-white" style="border-left: none;" type="email" name="email" id="email" placeholder="name@example.com" required>
                    </div>
                </div>

                <div class="mb-4 text-center">
                    <?= $captcha_display ?>
                </div>

                <button class="btn-primary-custom w-100 py-3 mb-4" type="submit">
                    <i class="fas fa-paper-plane me-2"></i>Send Reset Link
                </button>

                <div class="text-center">
                    <p class="text-secondary small">Remembered your password? <a href="<?= site_url('login') ?>" class="text-white text-decoration-none fw-bold">Sign In</a></p>
                </div>
            </form>
        </div>
    </div>
</div>

<style>
    .form-control:focus {
        background: transparent;
        color: white;
        border-color: var(--primary);
        box-shadow: 0 0 15px rgba(240, 5, 193, 0.2);
    }
    .input-group-text {
        border-radius: 12px 0 0 12px;
    }
    .form-control {
        border-radius: 0 12px 12px 0;
        padding: 12px 15px;
    }
</style>
