<div class="row g-4">
    <!-- User Overview -->
    <div class="col-lg-12">
        <div class="feature-card p-4" style="background: var(--primary-gradient); border: none;">
            <div class="row align-items-center">
                <div class="col-md-8">
                    <h2 class="text-white mb-2">Welcome Back, <span class="fw-bold"><?= $user['username'] ?></span>!</h2>
                    <p class="text-white-50 mb-0">You have earned <span class="text-white fw-bold"><?= currencyDisplay($user["total_earned"], $settings) ?></span> so far. Keep it up!</p>
                </div>
                <div class="col-md-4 text-md-end mt-3 mt-md-0">
                    <a href="<?= site_url('faucet') ?>" class="btn btn-light rounded-pill px-4 fw-bold text-primary">
                        <i class="fas fa-faucet me-2"></i>Claim Faucet
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="col-md-6 col-xl-3">
        <div class="dashboard-card text-center hover-lift">
            <div class="feature-icon mx-auto mb-3" style="width: 50px; height: 50px;"><i class="fas fa-wallet text-gradient"></i></div>
            <h5 class="text-secondary small text-uppercase">Balance</h5>
            <h3 class="text-white"><?= currencyDisplay($user['balance'], $settings) ?></h3>
        </div>
    </div>
    <div class="col-md-6 col-xl-3">
        <div class="dashboard-card text-center text-truncate hover-lift">
            <div class="feature-icon mx-auto mb-3" style="width: 50px; height: 50px;"><i class="fas fa-bolt text-gradient"></i></div>
            <h5 class="text-secondary small text-uppercase">Energy</h5>
            <h3 class="text-white"><?= $user['energy'] ?></h3>
        </div>
    </div>
    <div class="col-md-6 col-xl-3">
        <div class="dashboard-card text-center hover-lift">
            <div class="feature-icon mx-auto mb-3" style="width: 50px; height: 50px;"><i class="fas fa-users text-gradient"></i></div>
            <h5 class="text-secondary small text-uppercase">Referrals</h5>
            <h3 class="text-white"><?= $referralCount ?></h3>
        </div>
    </div>
    <div class="col-md-6 col-xl-3">
        <div class="dashboard-card text-center hover-lift">
            <div class="feature-icon mx-auto mb-3" style="width: 50px; height: 50px;"><i class="fas fa-medal text-gradient"></i></div>
            <h5 class="text-secondary small text-uppercase">Level</h5>
            <h3 class="text-white"><?= $user['level'] ?></h3>
        </div>
    </div>

    <!-- Progress Card -->
    <div class="col-lg-8">
        <div class="dashboard-card">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h4 class="text-white mb-0">Experience Progress</h4>
                <span class="text-gradient fw-bold"><?= ($user['exp'] % 100) ?>%</span>
            </div>
            <div class="progress mb-3" style="height: 12px; background: rgba(255,255,255,0.05); border-radius: 10px;">
                <div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" 
                     style="width: <?= ($user['exp'] % 100) ?>%; background: var(--primary-gradient); border-radius: 10px;"></div>
            </div>
            <p class="text-secondary small mb-0">
                <i class="fas fa-info-circle me-1"></i> You need <span class="text-white fw-bold"><?= ($user['level'] + 1) * 100 - $user['exp'] ?> exp</span> more to reach Level <?= $user['level'] + 1 ?>.
            </p>
        </div>
    </div>

    <!-- Daily Bonus Card -->
    <div class="col-lg-4">
        <div class="dashboard-card text-center">
            <h4 class="text-white mb-4">Daily Bonus</h4>
            <div class="mb-4">
                <img src="<?= base_url('assets/coinzi/dash/img/3dgift.png') ?>" alt="Gift" style="width: 80px;" class="animate__animated animate__pulse animate__infinite">
            </div>
            <form action="<?= site_url('/bonus/claim') ?>" method="POST">
                <input type="hidden" name="<?= $csrf_name ?>" value="<?= $csrf_hash ?>">
                <button type="submit" class="btn-primary-custom w-100" <?= $bonusAvailable ? '' : 'disabled' ?>>
                    <i class="fas fa-gift me-2"></i><?= $bonusAvailable ? 'Claim Bonus' : 'Already Claimed' ?>
                </button>
            </form>
        </div>
    </div>
</div>

<style>
    .dashboard-card {
        padding: 30px;
    }
</style>
