<div class="row">
    <div class="col-12">
        <div class="page-title-box">
            <h4 class="page-title">HugOffers Management</h4>
        </div>
    </div>
</div>

<?php if ($this->session->flashdata('message')): ?>
    <?= $this->session->flashdata('message') ?>
<?php endif; ?>

<!-- Statistics Cards -->
<div class="row">
    <div class="col-md-3">
        <div class="card">
            <div class="card-body">
                <div class="row align-items-center">
                    <div class="col-6">
                        <h5 class="text-muted fw-normal mt-0 text-truncate" title="Total Offers">Total Offers</h5>
                        <h3 class="my-2 py-1"><?= $stats['total_offers'] ?></h3>
                    </div>
                    <div class="col-6">
                        <div class="text-end">
                            <div id="total-offers-chart" data-colors="#727cf5"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-3">
        <div class="card">
            <div class="card-body">
                <div class="row align-items-center">
                    <div class="col-6">
                        <h5 class="text-muted fw-normal mt-0 text-truncate" title="Active Offers">Active Offers</h5>
                        <h3 class="my-2 py-1"><?= $stats['active_offers'] ?></h3>
                    </div>
                    <div class="col-6">
                        <div class="text-end">
                            <div id="active-offers-chart" data-colors="#0acf97"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-3">
        <div class="card">
            <div class="card-body">
                <div class="row align-items-center">
                    <div class="col-6">
                        <h5 class="text-muted fw-normal mt-0 text-truncate" title="Inactive Offers">Inactive</h5>
                        <h3 class="my-2 py-1"><?= $stats['inactive_offers'] ?></h3>
                    </div>
                    <div class="col-6">
                        <div class="text-end">
                            <div id="inactive-offers-chart" data-colors="#fa5c7c"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-3">
        <div class="card">
            <div class="card-body">
                <div class="row align-items-center">
                    <div class="col-6">
                        <h5 class="text-muted fw-normal mt-0 text-truncate" title="Total Conversions">Conversions</h5>
                        <h3 class="my-2 py-1"><?= number_format($stats['total_conversions']) ?></h3>
                    </div>
                    <div class="col-6">
                        <div class="text-end">
                            <div id="conversions-chart" data-colors="#ffbc00"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Quick Add Form -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <h4 class="header-title mb-3">Quick Add Offer</h4>
                <form action="<?= site_url('admin/hugoffers/quick_add') ?>" method="POST" class="row g-3">
                    <div class="col-md-4">
                        <label for="campid" class="form-label">Campaign ID</label>
                        <input type="text" class="form-control" id="campid" name="campid" placeholder="e.g., 8193" required>
                    </div>
                    <div class="col-md-3">
                        <label for="custom_payout" class="form-label">Custom Payout (USD)</label>
                        <input type="number" step="0.01" class="form-control" id="custom_payout" name="custom_payout" placeholder="0.40">
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">&nbsp;</label>
                        <div>
                            <button type="submit" class="btn btn-primary">Add Offer</button>
                            <small class="text-muted d-block">Will sync from API if available</small>
                        </div>
                    </div>
                    <input type="hidden" name="<?= $csrf_name ?>" value="<?= $csrf_hash ?>">
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Action Buttons -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <h4 class="header-title">Offers Management</h4>
                    <div>
                        <a href="<?= site_url('admin/hugoffers/add') ?>" class="btn btn-success">
                            <i class="mdi mdi-plus"></i> Add New Offer
                        </a>
                        <a href="<?= site_url('admin/hugoffers/bulk_import') ?>" class="btn btn-info">
                            <i class="mdi mdi-upload"></i> Bulk Import
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Offers Table -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>Campaign ID</th>
                                <th>Offer Name</th>
                                <th>Platform</th>
                                <th>Price (USD)</th>
                                <th>Custom Payout</th>
                                <th>Daily Cap</th>
                                <th>Conversions</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (!empty($offers)): ?>
                                <?php foreach ($offers as $offer): ?>
                                    <tr>
                                        <td>
                                            <strong><?= htmlspecialchars($offer['campid']) ?></strong>
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <?php 
                                                $image_url = '';
                                                if (!empty($offer['icon_link'])) {
                                                    $image_url = $offer['icon_link'];
                                                } elseif (!empty($offer['images'])) {
                                                    $images_data = json_decode($offer['images'], true);
                                                    if (is_array($images_data) && !empty($images_data)) {
                                                        $image_url = $images_data[0]['url'];
                                                    }
                                                }
                                                ?>
                                                <?php if (!empty($image_url)): ?>
                                                    <img src="<?= htmlspecialchars($image_url) ?>" 
                                                         alt="Icon" class="me-2" style="width: 32px; height: 32px; object-fit: cover; border-radius: 4px;"
                                                         onerror="this.style.display='none'">
                                                <?php endif; ?>
                                                <div>
                                                    <strong><?= htmlspecialchars($offer['offer_name']) ?></strong>
                                                    <?php if (!empty($offer['app_name']) && $offer['app_name'] != $offer['offer_name']): ?>
                                                        <br><small class="text-muted"><?= htmlspecialchars($offer['app_name']) ?></small>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <span class="badge bg-secondary"><?= htmlspecialchars($offer['platform']) ?></span>
                                            <?php if (!empty($offer['geo']) && $offer['geo'] != 'ALL'): ?>
                                                <br><small class="text-muted"><?= htmlspecialchars($offer['geo']) ?></small>
                                            <?php endif; ?>
                                        </td>
                                        <td>$<?= number_format($offer['price'], 2) ?></td>
                                        <td>
                                            <?php if ($offer['custom_payout']): ?>
                                                <span class="text-success">$<?= number_format($offer['custom_payout'], 2) ?></span>
                                            <?php else: ?>
                                                <span class="text-muted">-</span>
                                            <?php endif; ?>
                                        </td>
                                        <td><?= number_format($offer['daily_cap']) ?></td>
                                        <td><?= number_format($offer['conversion_count']) ?></td>
                                        <td>
                                            <?php if ($offer['is_enabled']): ?>
                                                <span class="badge bg-success">Active</span>
                                            <?php else: ?>
                                                <span class="badge bg-danger">Inactive</span>
                                            <?php endif; ?>
                                            <br>
                                            <small class="text-muted"><?= ucfirst($offer['status']) ?></small>
                                        </td>
                                        <td>
                                            <div class="btn-group btn-group-sm" role="group">
                                                <a href="<?= site_url('admin/hugoffers/toggle_status/' . $offer['id']) ?>" 
                                                   class="btn btn-outline-<?= $offer['is_enabled'] ? 'warning' : 'success' ?>" 
                                                   title="<?= $offer['is_enabled'] ? 'Disable' : 'Enable' ?>">
                                                    <i class="mdi mdi-<?= $offer['is_enabled'] ? 'pause' : 'play' ?>"></i>
                                                </a>
                                                <a href="<?= site_url('admin/hugoffers/sync/' . $offer['campid']) ?>" 
                                                   class="btn btn-outline-info" title="Sync from API">
                                                    <i class="mdi mdi-sync"></i>
                                                </a>
                                                <a href="<?= site_url('admin/hugoffers/delete/' . $offer['id']) ?>" 
                                                   class="btn btn-outline-danger" title="Delete"
                                                   onclick="return confirm('Are you sure you want to delete this offer?')">
                                                    <i class="mdi mdi-delete"></i>
                                                </a>
                                            </div>
                                            <?php if (!empty($offer['preview_link'])): ?>
                                                <br>
                                                <a href="<?= htmlspecialchars($offer['preview_link']) ?>" 
                                                   target="_blank" class="btn btn-sm btn-outline-secondary mt-1" title="Preview">
                                                    <i class="mdi mdi-open-in-new"></i> Preview
                                                </a>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="9" class="text-center">
                                        <div class="py-4">
                                            <i class="mdi mdi-folder-open-outline display-4 text-muted"></i>
                                            <h4 class="mt-3">No offers found</h4>
                                            <p class="text-muted">Start by adding your first HugOffers offer.</p>
                                            <a href="<?= site_url('admin/hugoffers/add') ?>" class="btn btn-primary">
                                                <i class="mdi mdi-plus"></i> Add First Offer
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <?php if ($pagination['total_pages'] > 1): ?>
                    <div class="d-flex justify-content-between align-items-center mt-3">
                        <div>
                            Showing <?= $pagination['per_page'] * ($pagination['current_page'] - 1) + 1 ?> to 
                            <?= min($pagination['per_page'] * $pagination['current_page'], $pagination['total_records']) ?> of 
                            <?= $pagination['total_records'] ?> entries
                        </div>
                        <nav>
                            <ul class="pagination pagination-sm mb-0">
                                <?php if ($pagination['current_page'] > 1): ?>
                                    <li class="page-item">
                                        <a class="page-link" href="?page=<?= $pagination['current_page'] - 1 ?>">Previous</a>
                                    </li>
                                <?php endif; ?>
                                
                                <?php for ($i = max(1, $pagination['current_page'] - 2); $i <= min($pagination['total_pages'], $pagination['current_page'] + 2); $i++): ?>
                                    <li class="page-item <?= $i == $pagination['current_page'] ? 'active' : '' ?>">
                                        <a class="page-link" href="?page=<?= $i ?>"><?= $i ?></a>
                                    </li>
                                <?php endfor; ?>
                                
                                <?php if ($pagination['current_page'] < $pagination['total_pages']): ?>
                                    <li class="page-item">
                                        <a class="page-link" href="?page=<?= $pagination['current_page'] + 1 ?>">Next</a>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </nav>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div> 