<div class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-body text-center">
                <h4 class="card-title mb-4">Daily Streak settings</h4>
                <?php
                if (isset($_SESSION['message'])) {
                    echo $_SESSION['message'];
                }
                ?>
                                <form action="<?= site_url('admin/daily_streak/update_req_earnings') ?>" method="POST" class="mb-4">
                    <input type="hidden" name="<?= $csrf_name ?>" value="<?= $csrf_hash ?>">
                    <div class="form-row justify-content-center align-items-end">
                        <div class="col-md-4">
                            <label>Required Earnings (USD)</label>
                            <input type="number" 
                                   name="req_earnings" 
                                   min="0.000001" 
                                   step="0.000001" 
                                   class="form-control" 
                                   value="<?= $req_earnings ?>" 
                                   required>
                        </div>
                        <div class="col-md-2">
                            <button type="submit" class="btn btn-primary btn-block">Update</button>
                        </div>
                    </div>
                </form>
                <hr>
                <?php foreach ($daily_streaks as $daily_streak) { ?>
                    <form action="<?= site_url('admin/daily_streak/edit/' . $daily_streak['id']) ?>" method="POST">
                        <input type="hidden" name="<?= $csrf_name ?>" id="token" value="<?= $csrf_hash ?>">
                        <div class="form-row mb-4">
                            <div class="col">
                                <label>Day</label>
                                <input type="day" name="day" class="form-control" value="<?= $daily_streak['day'] ?>" required="" disabled>

                            </div>
                            <div class="col">
                                <label>Usd Reward</label>
                                <input type="number" name="reward_usd" min="0.000001" step="0.000001" class="form-control" value="<?= $daily_streak['reward'] ?>" required="">
                            </div>
                            <div class="col">
                                <label>Weight (Day 7)</label>
                                <input type="number" name="weight" class="form-control" value="<?= $daily_streak['weight'] ?>" required="">
                            </div>
                            <div class="col">
                                <label>Actions</label>
                                <div style="display: block;">
                                    <button type="submit" class="btn btn-success btn-sm">Save</button>
                                    <a href="<?= site_url('admun/daily_streak/delete/' . $daily_streak['id']) ?>" class="btn btn-danger btn-sm">Delete</a>
                                </div>
                            </div>
                        </div>
                    </form>
                <?php } ?>
                <hr>

                <form action="<?= site_url('admin/daily_streak/add/') ?>" method="POST">
                    <input type="hidden" name="<?= $csrf_name ?>" id="token" value="<?= $csrf_hash ?>">
                        <div class="form-row mb-4">
                            <div class="col">
                                <label>Day</label>
                                <input type="day" name="day" class="form-control" value="7" required="" disabled>

                            </div>
                            <div class="col">
                                <label>Usd Reward</label>
                                <input type="number" name="reward_usd" min="0.000001" step="0.000001" class="form-control" value="" required="">
                            </div>
                            <div class="col">
                                <label>Weight (Day 7)</label>
                                <input type="number" name="weight" class="form-control" value="" required="">
                            </div>
                            <div class="col">
                                <label>Actions</label>
                                <div style="display: block;">
                                    <button type="submit" class="btn btn-success btn-sm">Add</button>
                                </div>
                            </div>
                        </div>
                </form>
            </div>
        </div>
    </div>
</div>