<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Theme
{
    protected $CI;

    public function __construct()
    {
        $this->CI = &get_instance();
    }

    /**
     * Render a view within the master template
     * 
     * @param string $view   The view file located in application/views/
     * @param array  $data   Data to pass to the view
     * @param string $title  Page title
     */
    public function render($view, $data = [], $title = '')
    {
        if (!empty($title)) {
            $data['page'] = $title;
        }

        // Capture the content of the specific page view
        $data['contents'] = $this->CI->load->view($view, $data, true);

        // Load the master template with the injected content
        $this->CI->load->view('user_template/template', $data);
    }
}
