<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Methods extends Admin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->library('form_validation');
    }
    public function index()
    {
        $this->data['page'] = 'Payment Methods';
        $this->data['methods'] = $this->m_admin->getMethod();
        $this->render('methods', $this->data);
    }
    public function add()
    {
        $name = $this->db->escape_str($this->input->post('name'));
        $currencyName = $this->db->escape_str($this->input->post('currency_name'));
        $code = $this->db->escape_str($this->input->post('code'));
        $api = $this->db->escape_str($this->input->post('api'));
        $token = $this->db->escape_str($this->input->post('token'));
        $wallet = $this->db->escape_str($this->input->post('wallet'));
        $price = $this->db->escape_str($this->input->post('price'));
        $cost = $this->db->escape_str($this->input->post('cost'));
        $accountNumber = $this->db->escape_str($this->input->post('account_number'));
        $apiId = $this->db->escape_str($this->input->post('api_id'));
        $minimumWithdrawal = $this->db->escape_str($this->input->post('minimum_withdrawal'));
        $tokenId = $this->db->escape_str($this->input->post('token_id'));
        $this->m_admin->addMethod($name, $currencyName, $code, $api, $token, $wallet, $price, $cost, $accountNumber, $apiId, $minimumWithdrawal, $tokenId);
        redirect(site_url('admin/methods'));
    }
    public function delete($id = 0)
    {
        $this->db->delete('methods', array('id' => $id));
        redirect(site_url('admin/methods'));
    }
    public function update($id = 0)
    {
        $name = $this->db->escape_str($this->input->post('name'));
        $currencyName = $this->db->escape_str($this->input->post('currency_name'));
        $code = $this->db->escape_str($this->input->post('code'));
        $api = $this->db->escape_str($this->input->post('api'));
        $token = $this->db->escape_str($this->input->post('token'));
        $wallet = $this->db->escape_str($this->input->post('wallet'));
        $price = $this->db->escape_str($this->input->post('price'));
        $cost = $this->db->escape_str($this->input->post('cost'));
        $status = $this->db->escape_str($this->input->post('status'));
        $accountNumber = $this->db->escape_str($this->input->post('account_number'));
        $apiId = $this->db->escape_str($this->input->post('api_id'));
        $minimumWithdrawal = $this->db->escape_str($this->input->post('minimum_withdrawal'));
        $tokenId = $this->db->escape_str($this->input->post('token_id'));
        $this->m_admin->updateMethod($id, $name, $currencyName, $code, $api, $token, $wallet, $price, $cost, $accountNumber, $apiId, $minimumWithdrawal, $tokenId, $status);
        redirect(site_url('admin/methods'));
    }
}
