<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Referral_milestones extends Member_Controller
{
    public function __construct()
    {
        parent::__construct();

        $this->load->model('m_referral_milestones');
        $this->load->model('m_account');
    }

    public function index()
    {
        $this->data['page'] = 'Referral Milestones';
        $this->data['milestones'] = $this->m_referral_milestones->getMilestones($this->data['user']['id']);

$total_referrals = $this->m_account->getTotalReferrals($this->data['user']['id'], $this->data['settings']['ref_req']);
        $this->data['total_referrals'] = $total_referrals; 

for ($i = 0; $i < count($this->data['milestones']); ++$i) {
    // force referral type only
    $this->data['milestones'][$i]['name'] = 'referrals';
    $this->data['milestones'][$i]['completed'] = $total_referrals;
    $this->data['milestones'][$i]['reward_usd'] = $this->data['milestones'][$i]['reward_usd'];
    $this->data['milestones'][$i]['description'] = 'Get ' . $this->data['milestones'][$i]['condition'] . ' referrals';

    $condition = (int) $this->data['milestones'][$i]['condition'];

    if ($condition > 0) {
        $this->data['milestones'][$i]['progress'] = min(100, $total_referrals * 100 / $condition);
    } else {
        // Decide how to treat condition = 0
        // Either already complete:
        $this->data['milestones'][$i]['progress'] = 100;
        // Or not applicable:
        // $this->data['milestones'][$i]['progress'] = 0;
    }
}

        $this->render('referral_milestones', $this->data);
    }

    public function claim($id = 0)
    {
        if (!is_numeric($id)) {
            return redirect('referral_milestones');
        }

        $milestones = $this->m_referral_milestones->getMilestoneFromId($id);
        if (!$milestones) {
            return redirect('referral_milestones');
        }

        // check history (already claimed?)
        if (!$this->m_referral_milestones->checkHistory($id, $this->data['user']['id'])) {
            return redirect('referral_milestones');
        }

        // referral requirement check
        $total_referrals = $this->m_account->getTotalReferrals($this->data['user']['id']);
        if ($milestones['condition'] > $total_referrals) {
            return redirect(site_url('referral_milestones'));
        }

        // reward user
        $this->m_core->rewardUser(
            $this->data['user'],
            'referral_milestones',
            $milestones['reward_usd'],
            0,
            0,
            0,
            $this->data['settings']['referral']
        );

        // save achievement history
        $this->m_referral_milestones->insertHistory(
            $this->data['user']['id'],
            $milestones['id'],
            $milestones['reward_usd']
        );

        $this->session->set_flashdata(
            'sweet_message',
            faucet_sweet_alert(
                'success',
                currencyDisplay($milestones['reward_usd'], $this->data['settings']) .
                ' has been added to your balance'
            )
        );

        return redirect(site_url('/referral_milestones'));
    }
}
