<!-- card lg withdraw -->
<div class="row section px-3">
  <div class="col-12">
    <div class="card-lg text-start align-items-start mb-3 mb-lg-0">

    <?php
        if (isset($_SESSION['message'])) {
          echo $_SESSION['message'];
        }
        ?>
      <h2 class="mb-3">Withdraw</h2>



      <form action="<?= site_url('withdraw/withdraw') ?>" method="POST" autocomplete="off" class="w-100">
      <?php
          if (isset($_SESSION['withdraw_message'])) {
            echo $_SESSION['withdraw_message'];
          }
          ?>
          <input type="hidden" name="<?= $csrf_name ?>" value="<?= $csrf_hash ?>">
        <p class="mb-3">Currency:</p>
        <div class="row">
              <script>
                var currencies = [];
                var minimumWithdrawals = [];
                var rate = <?= $settings['currency_rate'] ?>;
              </script>
              <?php foreach ($methods as $method) {
                $percent = number_format(min(100, $method['balance'] * $method['price'] * 100)); ?>
                <div class="col-xl-4 col-sm-6">
                  <div class="mb-3">
                    <label class="card-radio-label mb-2">
                      <input type="radio" name="method" value="<?= $method['id'] ?>" class="card-radio-input" checked="" required>
                      <div class="card-radio">
                        <div>
                          <img class="currency-dashboard" src="<?= site_url('assets/images/currencies/' . strtolower($method['code']) . '.png') ?>" />
                          <span><?= $method['name'] ?></span>
                        </div>

                        <script>
                      currencies['<?= $method['id'] ?>'] = {
                        price: <?= $method['price'] ?>,
                        code: '<?= $method['code'] ?>',
                        minimumWithdrawal: <?= $method['minimum_withdrawal'] ?>
                      };
                    </script>
                    <div>
                      <p class="mb-1">Current rate:</p>
                      <h5 class="font-size-14">1 <?= $method['code'] ?> = <?= currencyDisplay($method['price'], $settings) ?></h5>
                    </div>
                    <div>

                      <span class="fw-bold d-block">Faucet Balance:</span>
                      <div class="progress">
                        <div class="progress-bar" role="progressbar" aria-valuenow="<?= $percent ?>" aria-valuemin="0" aria-valuemax="100" style="width: <?= $percent ?>%">
                          <?= $percent ?>%
                        </div>
                      </div>
                    </div>
                      </div>

                    </label>
                    
                  </div>
                </div>
              <?php } ?>
            </div>
        <label class="form-label">Amount</label>
        <div class="row">
              <div class="col-sm-6">
                <div class="input-group mb-2 currency-value">
                  <div class="input-group-prepend">
                    <span class="input-group-text">Coinz Balance</span>
                  </div>
                  <input type="number" name="amount" id="tokenBalance" value="<?= $user['balance'] / $settings['currency_rate'] ?>" class="form-control" min="0.000001" max="<?= $user['balance'] / $settings['currency_rate'] ?>" step="0.000001">
                </div>
              </div>

              <div class="col-sm-6">
                <div class="input-group mb-2">
                  <input type="text" id="converted" class="form-control text-sm-right" disabled>

                  <div class="input-group-append">
                    <span class="input-group-text" id="targetCurrency">You will receive</span>
                  </div>
                </div>
              </div>
            </div>
            <small id="minimumWithdrawal"></small>
<br>
        <label class="form-label">Wallet</label>
        <div class="input-wrap mb-3">
          <div class="input-icon">
            <i class="fa-solid fa-wallet"></i>
          </div>
          <input class="form-input" placeholder="Enter Your Payment Email ** NOT COIN ADDRESS ** " type="text" name="wallet" value="<?= $user['wallet'] ?>">
        </div>

        <div class="mb-4">
        <center>
                     <?= $captcha_display ?>
        </center>
        </div>

        <button type="submit" class="btn-one">Withdraw</button>
      </form>
    </div>
  </div>
</div>