<div class="ads">
    <?= $settings['dashboard_top_ad'] ?>
</div>
<!-- refer link -->
<div class="row section px-3">
    <div class="col-lg-12">
        <div class="refer-wrap">
            <div class="row align-items-center">
                <div class="col-lg-8">
                    <h4 class="fw-bold mb-2">Refer &amp; earn</h4>
                    <p class="mb-3">Currently Referral Commission is <?= $settings['referral'] ?>%</p>

                    <div class="refer-link-wrap">
                        <input type="text" id="refer-link" readonly="" value="<?= site_url('/?r=' . $user['id']) ?>">
                        <button type="button" id="copy-btn">
                            <i class="fas fa-copy"></i>
                        </button>
                    </div>
                </div>

                <div class="d-none d-lg-block col-lg-4 text-center">
                    <h4 class="display-1 fw-bold" style="color: #8077fb;"><?= $settings['referral'] ?>%</h4>
                    <h2>Bonus</h2>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- refer table -->
<div class="row section px-3">
    <div class="col-12">
        <div class="rounded-bg">
            <h2 class="title-sm">Your Last 100 Referrals</h2>
            <div class="overflow-x">
                <table class="data-table">
                    <thead>
                        <tr>
                            <th>Username</th>
                            <th>Last Active</th>
                            <th>Total Earned</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php
                            foreach ($referrals as $referral) {
                                echo '<tr><th>' . $referral["username"] . '</th><td>' . timespan($referral["last_active"], time(), 2) . ' ago</td><td>' . format_money($referral["total_earned"]) . '</td></tr>';
                            }
                            ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>