<style>
    .card-radio-label {
    display: block;
}

.card-radio-input {
    display: none;
}

.card-radio {
    background: hsl(273deg 96% 64% / 20%);
    gap: 10px;
    display: flex;
    flex-direction: column;
    min-height: 138px;
    position: relative;
    border-radius: 12px;
    margin-bottom: 18px;
    padding: 22px 28px;
    backdrop-filter: blur(12px);
    justify-content: space-between;
    border: 2px solid #525EA8;
    background: hsl(273deg 96% 64% / 20%);
}

.card-radio img {
    width: 200px;
}

.card-radio-input:checked + .card-radio {
    border-color: #9C27B0 !important;
    background: hsl(300deg 100% 25% / 30%);
}

.currency-dashboard {
    height: auto;
    max-width: 120px;
    max-height: 117px;
}

.card-title {
    margin-top: 15px;
    font-size: 1.25rem;
}

</style>
<!-- card lg withdraw -->
<div class="row section px-3">
  <div class="col-12">
    <div class="card-lg text-start align-items-start mb-3 mb-lg-0">

    <?php
        if (isset($_SESSION['message'])) {
          echo $_SESSION['message'];
        }
        ?>
      <h2 class="mb-3">Withdraw</h2>



      <form action="<?= site_url('payout/withdraw') ?>" method="POST" autocomplete="off" class="w-100">
      <?php
          if (isset($_SESSION['withdraw_message'])) {
            echo $_SESSION['withdraw_message'];
          }
          ?>
          <input type="hidden" name="<?= $csrf_name ?>" value="<?= $csrf_hash ?>">
        <p class="mb-3">Currency:</p>
        <div class="row">
              <script>
                var currencies = [];
                var minimumWithdrawals = [];
                var rate = <?= $settings['currency_rate'] ?>;
              </script>
              <?php foreach ($methods as $method) {
                $percent = number_format(min(100, $method['balance'] * $method['price'] / 30 * 100)); ?>
        <div class="col-md-4">
            <label class="card-radio-label">
                <input type="radio" name="method" value="<?= $method['id'] ?>" class="card-radio-input" checked="" required>
                <div class="card-body card-radio">
                    <div class="d-flex flex-column align-items-center">
                         <h6 class="mb-2"><?= currencyDisplay($method['cost'], $settings) ?></h6>
                        <img class="currency-dashboard" src="<?= site_url('assets/images/currencies/' . strtolower($method['currency_name']) . '.png') ?>" alt="" style="height: auto; max-width: 120px; max-height: 117px;">
                        <h6 class="input-group-text"><?= rtrim(rtrim(number_format($method['minimum_withdrawal'], 8), '0'), '.') ?> <?= $method['code'] ?></h6>
                         <span><?= $method['name'] ?></span>
                    </div>
                </div>
            </label>
        </div>
        <script>
            currencies['<?= $method['id'] ?>'] = {
                price: <?= $method['price'] ?>,
                code: '<?= $method['code'] ?>',
                minimumWithdrawal: <?= $method['minimum_withdrawal'] ?>
            };
        </script>
    <?php } ?>
            </div>
<br>
        <label class="form-label">Wallet</label>
        <div class="input-wrap mb-3">
          <div class="input-icon">
            <i class="fa-solid fa-wallet"></i>
          </div>
          <input class="form-input" placeholder="Enter Your Payment Email ** NOT COIN ADDRESS ** " type="text" name="wallet" value="<?= $user['wallet'] ?>">
        </div>

        <div class="mb-4">
        <?= $captcha_display ?>
        </div>

        <button type="submit" class="btn-one">Withdraw</button>
      </form>
    </div>
  </div>
</div>