<div class="ads">
    <?= $settings['dashboard_top_ad'] ?>
</div>
<!-- notice -->
<div class="row section px-3">
    <div class="col-12">
        <div class="notice-bar">
            <p>Weekly Leaderboard Resets In <span class="fw-bold"><?= timespan(time(), $leaderboardSettings["leaderboard_date"], 2) ?></span> and updated every 10 minutes!
            </p>
        </div>
    </div>
</div>

<!-- leaderboard table -->
<div class="row section px-3">
    <div class="col-12">
        <div class="rounded-bg">
            <ul class="nav nav-pills flex-wrap justify-content-center mb-4" id="pills-tab" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="" data-bs-toggle="pill" data-bs-target="#pills-level" type="button" role="tab" aria-controls="pills-profile" aria-selected="true">Level</button>
                </li>

                <?php if ($leaderboardSettings['activity_contest_reward'] != "") {
        $rewards = explode('|', $leaderboardSettings['activity_contest_reward'])
    ?>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="" data-bs-toggle="pill" data-bs-target="#pills-activity" type="button" role="tab" aria-controls="pills-home" aria-selected="false" tabindex="-1">Activity</button>
                </li>

                <?php } ?>

                <?php if ($leaderboardSettings['faucet_contest_reward'] != "") {
        $rewards = explode('|', $leaderboardSettings['faucet_contest_reward'])
    ?>

                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="" data-bs-toggle="pill" data-bs-target="#pills-faucet" type="button" role="tab" aria-controls="pills-home" aria-selected="false" tabindex="-1">Faucet</button>
                </li>

                <?php } ?>

                <?php if ($leaderboardSettings['shortlink_contest_reward'] != "") {
        $rewards = explode('|', $leaderboardSettings['shortlink_contest_reward'])
    ?>

                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="" data-bs-toggle="pill" data-bs-target="#pills-links" type="button" role="tab" aria-controls="pills-home" aria-selected="false" tabindex="-1">Shortlink</button>
                </li>

                <?php } ?>


                <?php if ($leaderboardSettings['offerwall_contest_reward'] != "") {
        $rewards = explode('|', $leaderboardSettings['offerwall_contest_reward'])
    ?>

                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="" data-bs-toggle="pill" data-bs-target="#pills-offers" type="button" role="tab" aria-controls="pills-home" aria-selected="false" tabindex="-1">Offerwall</button>
                </li>

                <?php } ?>
            </ul>

            <div class="tab-content" id="">
                <div class="tab-pane fade active show" id="pills-level" role="tabpanel" aria-labelledby="pills-profile-tab">
                    <!-- TODO:  -->
                    <div>
                        <h5 class="text-center mb-1">Level Leaderboard</h5>
                        <p class="text-center mb-3">Top 20 highest level users!</p>
                        <div class="table-responsive">
                            <table class="data-table">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Username</th>
                                        <th>Level</th>
                                    </tr>
                                </thead>

                                <tbody>
                                <?php
                            $rank = 1;
                            foreach ($topLevel as $u) {
                                echo '<tr><th scope="row">' . $rank++ . '</th><td class="username-rank">' . $u["username"] . '</td><td>' . $u["level"] . '</td></tr>';
                            }
                            ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <?php if ($leaderboardSettings['activity_contest_reward'] != "") {
        $rewards = explode('|', $leaderboardSettings['activity_contest_reward'])
    ?>

                <div class="tab-pane fade" id="pills-activity" role="tabpanel" aria-labelledby="pills-home-tab">
                    <!-- TODO:  -->
                    <div>
                        <h5 class="text-center mb-1">Activity Leaderboard</h5>
                        <p class="text-center mb-3">Top 20 claimers of this week! Your exp earned this week: <?= $user['claims'] ?></p>
                        <div class="table-responsive">
                            <table class="data-table">
                                <thead>
                                    <tr>
                                    <th>#</th>
                                    <th>Username</th>
                                    <th>Level</th>
                                    <th>Exp</th>
                                    <th>Reward</th>
                                    </tr>
                                </thead>

                                <tbody>
                                <?php
                                $rank = 0;
                                foreach ($topClaimer as $u) {
                                    $reward = $rank < count($rewards) ? $rewards[$rank] : 0;
                                    echo '<tr><th scope="row">' . ++$rank . '</th><td class="username-rank">' . $u["username"] . '</td><td>' . $u["level"] . '</td><td>' . $u["claims"] . '</td><td>' . currencyDisplay($reward, $settings) . '</td></tr>';
                                }
                                ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <?php } ?>

                <?php if ($leaderboardSettings['faucet_contest_reward'] != "") {
        $rewards = explode('|', $leaderboardSettings['faucet_contest_reward'])
    ?>

                <div class="tab-pane fade" id="pills-faucet" role="tabpanel" aria-labelledby="pills-home-tab">
                    <!-- TODO:  -->
                    <div>
                    <h5 class="text-center mb-1">Faucet Leaderboard</h5>
                        <p class="text-center mb-3">Top 20 users of faucet contest! Your faucet claim this week: <?= $user['faucet_count_tmp'] ?></p>
                        <div class="table-responsive">
                            <table class="data-table">
                                <thead>
                                    <tr>
                                    <th>#</th>
                                    <th>Username</th>
                                    <th>Level</th>
                                    <th>Claims</th>
                                    <th>Reward</th>
                                    </tr>
                                </thead>

                                <tbody>
                                <?php
                                $rank = 0;
                                foreach ($topFaucet as $u) {
                                    $reward = $rank < count($rewards) ? $rewards[$rank] : 0;
                                    echo '<tr><th scope="row">' . ++$rank . '</th><td class="username-rank">' . $u["username"] . '</td><td>' . $u["level"] . '</td><td>' . $u["faucet_count_tmp"] . '</td><td>' . currencyDisplay($reward, $settings) . '</td></tr>';
                                }
                                ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <?php } ?>

                <?php if ($leaderboardSettings['shortlink_contest_reward'] != "") {
        $rewards = explode('|', $leaderboardSettings['shortlink_contest_reward'])
    ?>

                <div class="tab-pane fade" id="pills-links" role="tabpanel" aria-labelledby="pills-home-tab">
                    <!-- TODO:  -->
                    <div>
                    <h5 class="text-center mb-1">Shortlink Leaderboard</h5>
                        <p class="text-center mb-3">Top 20 users of shortlink contest! Your shortlink claim this week: <?= $user['shortlink_count_tmp'] ?></p>
                        <div class="table-responsive">
                            <table class="data-table">
                                <thead>
                                    <tr>
                                    <th>#</th>
                                    <th>Username</th>
                                    <th>Level</th>
                                    <th>Claims</th>
                                    <th>Reward</th>
                                    </tr>
                                </thead>

                                <tbody>
                                <?php
                                $rank = 0;
                                foreach ($topShortlink as $u) {
                                    $reward = $rank < count($rewards) ? $rewards[$rank] : 0;
                                    echo '<tr><th scope="row">' . ++$rank . '</th><td class="username-rank">' . $u["username"] . '</td><td>' . $u["level"] . '</td><td>' . $u["shortlink_count_tmp"] . '</td><td>' . currencyDisplay($reward, $settings) . '</td></tr>';
                                }
                                ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <?php } ?>

                <?php if ($leaderboardSettings['offerwall_contest_reward'] != "") {
        $rewards = explode('|', $leaderboardSettings['offerwall_contest_reward'])
    ?>

                <div class="tab-pane fade" id="pills-offers" role="tabpanel" aria-labelledby="pills-home-tab">
                    <!-- TODO:  -->
                    <div>
                    <h5 class="text-center mb-1">Offerwalls Leaderboard</h5>
                        <p class="text-center mb-3">Top 20 users of offerwall contest! Your offerwall claim this week: <?= $user['offerwall_count_tmp'] ?></p>
                        <div class="table-responsive">
                            <table class="data-table">
                                <thead>
                                    <tr>
                                    <th>#</th>
                                    <th>Username</th>
                                    <th>Level</th>
                                    <th>Claims</th>
                                    <th>Reward</th>
                                    </tr>
                                </thead>

                                <tbody>
                                <?php
                                $rank = 0;
                                foreach ($topOfferwall as $u) {
                                    $reward = $rank < count($rewards) ? $rewards[$rank] : 0;
                                    echo '<tr><th scope="row">' . ++$rank . '</th><td class="username-rank">' . $u["username"] . '</td><td>' . $u["level"] . '</td><td>' . $u["offerwall_count_tmp"] . '</td><td>' . currencyDisplay($reward, $settings) . '</td></tr>';
                                }
                                ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <?php } ?>
            </div>
        </div>
    </div>
</div>