<style>
    /* Root Colours - Matching Coinzi Theme */
    :root {
        --bg-dark: #0A0E17;
        --bg-card: #151B2D;
        --text-light: #ffffff;
        --accent-gradient: linear-gradient(135deg, #6a11cb 0%, #2575fc 100%);
        --glow-color: rgba(101, 204, 255, 0.6);
    }


    .streak-container {
        background: var(--bg-card);
        padding: 2rem;
        border-radius: 16px;
        text-align: center;
        box-shadow: 0 0 20px rgba(0,0,0,0.6);
        width: 90%;
        max-width: 500px;
        position: relative;
        overflow: hidden;
    }

    .streak-container::before {
        content: "";
        position: absolute;
        top: -50%;
        left: -50%;
        width: 200%;
        height: 200%;
        background: var(--accent-gradient);
        animation: rotate-gradient 8s linear infinite;
        z-index: 0;
        opacity: 0.1;
    }

    @keyframes rotate-gradient {
        to { transform: rotate(360deg); }
    }

    .streak-title {
        font-size: 1.8rem;
        margin-bottom: 1rem;
        font-weight: 700;
        background: #ffffff;
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        position: relative;
        z-index: 1;
    }
        .streak-title2 {
        font-size: 1rem;
        margin-bottom: 1rem;
        font-weight: 700;
        background: #ffffff;
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        position: relative;
        z-index: 1;
    }



    .day {
        flex: 1;
        background: #1F263D;
        padding: 1rem;
        border-radius: 12px;
        transition: all 0.3s ease;
        position: relative;
    }

    .day.active {
        background: var(--accent-gradient);
        box-shadow: 0 0 15px var(--glow-color);
        transform: scale(1.05);
    }

    .day span {
        font-size: 0.8rem;
        display: block;
        opacity: 0.75;
    }

    .day strong {
        font-size: 1.3rem;
        display: block;
    }

    .claim-btn {
        background: var(--accent-gradient);
        border: none;
        padding: 0.8rem 1.5rem;
        font-weight: 600;
        border-radius: 10px;
        colour: white;
        cursor: pointer;
        transition: 0.3s ease;
        position: relative;
        z-index: 1;
    }

    .claim-btn:hover {
        box-shadow: 0 0 20px var(--glow-color);
        transform: translateY(-2px);
    }
.streak-days {
  display: grid;
  grid-template-columns: repeat(3, 1fr);
  gap: 15px;
  max-width: 600px;
  margin: 0 auto;
}

.streak-days .day.big-day {
  grid-column: span 3; /* full row */
  font-size: 1.4rem;
  padding: 20px;
  border: 2px solid gold;
  border-radius: 12px;
  background: #2F1C53;
}
/* Tablet: 2 per row */
@media (max-width: 768px) {
  .streak-days {
    grid-template-columns: repeat(2, 1fr);
  }
  .streak-days .day.big-day {
    grid-column: span 2; /* full width for row */
  }
}

/* Mobile: 1 per row */
@media (max-width: 480px) {
  .streak-days {
    grid-template-columns: 1fr;
  }
  .streak-days .day.big-day {
    grid-column: span 1;
  }
}
.bg-streak-active {
    background-color: #E2796A !important;
    color: #fff !important;
}
.bg-streak-inactive {
    background-color: #B61AC2 !important;
    color: #fff !important;
}
/* Pulse effect for current unclaimed day */
.day.current-today {
    animation: pulse 1.5s infinite;
    border: 2px solid #E2796A;
}

@keyframes pulse {
    0% { box-shadow: 0 0 5px #E2796A; transform: scale(1); }
    50% { box-shadow: 0 0 15px #E2796A; transform: scale(1.05); }
    100% { box-shadow: 0 0 5px #E2796A; transform: scale(1); }
}
</style>
<style>
    .acv-bar-fill, .exp-bar-fill {
    height: 20px;
    background: #c13dab;
}
</style>
<div class="row justify-content-center px-3">
<div class="col-12 col-md-7">
        <div class="rounded-bg text-center">
            <h2 class="streak-title">Daily Streak Bonus - <span id="streak-timer">--:--:--</span></h2>
            <p>    <?php
$earned = $user['earned_today'];
$target = $settings['req_earnings'];

// Avoid division by zero and cap at 100%
$progress = $target > 0 ? min(100, ($earned / $target) * 100) : 0;
?>
            <div class="exp-bar mb-4" style="height: 20px;">
<div class="exp-bar-fill" role="progressbar"
     style="width: <?= $progress ?>%;"
     aria-valuenow="<?= $progress ?>"
     aria-valuemin="0" aria-valuemax="100">
</div>
</div></p>
            <h2 class="streak-title2">Required Earnings - <?= currencyDisplay($user['earned_today'], $settings) ?> / <?= currencyDisplay(0.10, $settings) ?></h2>
                <?php $current_day = $streak['current_day'] ?? 0; ?>
<div class="streak-days">
<?php 
$today = date('Y-m-d');
$last_claim = $streak['last_claim'] ?? null;
$current_day = $streak['current_day'] ?? 1;

// Determine which day should pulse
if ($last_claim === null) {
    $claimable_day = 1;
    $current_day = 0; // nothing claimed yet
} elseif ($last_claim == $today) {
    $claimable_day = 0; // already claimed today
} elseif ($last_claim == date('Y-m-d', strtotime('-1 day'))) {
    if ($current_day >= 7) {
        // Completed the streak, reset
        $claimable_day = 1;
        $current_day = 0;
    } else {
        $claimable_day = $current_day + 1;
    }
} else {
    // Missed a day → reset streak
    $claimable_day = 1;
    $current_day = 0;
}

// Filter day 7 rewards to show single box
$day7_rewards = array_filter($rewards, function($r) {
    return $r['day'] == 7;
});

foreach ($rewards as $reward): 
    $day = $reward['day'];

    // Skip duplicate day 7 rows
    if ($day == 7 && $reward !== reset($day7_rewards)) continue;

    if ($day < 7) {
        if ($day <= $current_day) {
            $day_class = 'bg-streak-active';
            $display_reward = 'CLAIMED';
        } elseif ($day == $claimable_day) {
            $day_class = 'bg-streak-inactive current-today';
            $display_reward = currencyDisplay($reward['reward'], $settings);
        } else {
            $day_class = 'bg-streak-inactive';
            $display_reward = currencyDisplay($reward['reward'], $settings);
        }
    } else {
        // Day 7 box
        if ($current_day == 7 && $last_claim == $today) {
            $day_class = 'bg-streak-active big-day';
            $display_reward = 'CLAIMED';
        } elseif ($claimable_day == 7) {
            $day_class = 'bg-streak-inactive big-day current-today';
            $display_reward = "Up to " . currencyDisplay($max_reward, $settings);
        } else {
            $day_class = 'bg-streak-inactive big-day';
            $display_reward = "Up to " . currencyDisplay($max_reward, $settings);
        }
    }
?>
    <div class="day <?= $day_class ?>">
        <span>Day <?= $day ?></span>
        <strong><?= $display_reward ?></strong>
    </div>
<?php endforeach; ?>
</div>
</br>
<form action="<?= site_url('daily_streak/claim') ?>" method="post" id="daily-streak-form">
    <input type="hidden" name="<?= $csrf_name ?>" value="<?= $csrf_hash ?>">
    <button class="claim-btn" id="claimBtn"
        <?php if (isset($streak['last_claim']) && $streak['last_claim'] == date('Y-m-d')) echo 'disabled'; ?>>

        <?php if (isset($streak['last_claim']) && $streak['last_claim'] >= date('Y-m-d')): ?>
            Already Claimed
        <?php else: ?>
            Claim Today’s Reward
        <?php endif; ?>
    </button>
</form>

        </div>
    </div>

<div class="streak-info mt-4 p-3 rounded-bg text-start">
    <h3 class="mb-3">7-Day Streak Rewards</h3>
    <p>
        Keep your streak alive by reaching the required daily earnings goal. <br>
        Each consecutive day you claim increases your bonus, so the rewards 
        grow the longer you stay on track.
    </p>

    <h4 class="mt-3">How It Works?</h4>
    <ul>
        <li>Earn the minimum Coinz each day to keep your streak going.</li>
        <li>Rewards scale up daily, encouraging consistency.</li>
        <li>If you miss a day, the streak resets back to Day 1.</li>
    </ul>

    <h4 class="mt-3">Special Day 7 Reward</h4>
    <p>
        On the 7th day, you’ll unlock a special chance-based reward:  
         <?php foreach ($day7_probs as $p): ?>
         <br><strong><?= $p['chance'] ?>% chance</strong> to win <strong><?= currencyDisplay($p['reward'], $settings) ?></strong>
        <?php endforeach; ?>
    </p>
</div>

</div>

<script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
<?php if ($this->session->flashdata('sweet_alert')): 
    $sa = $this->session->flashdata('sweet_alert'); ?>
Swal.fire({
    title: "<?= $sa['title'] ?>",
    text: "<?= $sa['text'] ?>",
    icon: "<?= $sa['icon'] ?>",
    confirmButtonText: "OK"
});
<?php endif; ?>

document.querySelector('#daily-streak-form').addEventListener('submit', function(e){
    this.querySelector('button[type=submit]').disabled = true;
});

// Countdown timer
function updateStreakTimer() {
    let serverNow = new Date("<?= date('Y-m-d H:i:s') ?>"); 
    let clientNow = new Date();
    let offset = serverNow.getTime() - clientNow.getTime();

    setInterval(() => {
        let now = new Date(new Date().getTime() + offset);
        let midnight = new Date(now);
        midnight.setHours(24,0,0,0);
        let diff = midnight - now;

        if (diff <= 0) {
            location.reload();
        }

        let hours = Math.floor(diff / (1000*60*60));
        let minutes = Math.floor((diff % (1000*60*60)) / (1000*60));
        let seconds = Math.floor((diff % (1000*60)) / 1000);

        document.getElementById('streak-timer').textContent =
            `${hours.toString().padStart(2,'0')}:${minutes.toString().padStart(2,'0')}:${seconds.toString().padStart(2,'0')}`;
    }, 1000);
}

updateStreakTimer();
</script>