<div class="ads">
    <?= $settings['coinflip_top_ad'] ?>
</div>
<div class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title mb-4 text-center">Coin Flip Game</h4>
                <div class="row">
                    <div class="col-md-6">
                        <form id="betForm">
                            <div id="result"></div>
                            <div class="row">
                                <div class="col-md-12">
                                    <label for="betAmount">Bet Amount</label>
                                    <div class="input-group mb-2 mr-sm-3">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text"><i class="far fa-money-bill-alt"></i></div>
                                        </div>
                                        <input type="number" class="form-control" id="betAmount" value="<?= $settings['coinflip_min_bet'] / $settings['currency_rate'] ?>" min="<?= $settings['coinflip_min_bet'] / $settings['currency_rate'] ?>" max="<?= $settings['coinflip_max_bet'] / $settings['currency_rate'] ?>" step="1" placeholder="Bet Amount">
                                        <div class="input-group-append">
                                            <button type="button" id="half" class="btn btn-warning btn-sm">/2</button>
                                        </div>
                                        <div class="input-group-append">
                                            <button type="button" id="double" class="btn btn-success btn-sm">x2</button>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6"><button type="submit" id="betBTC" class="btn btn-block btn-warning bet-btn" data-coin="BTC">Bet on Bitcoin</button></div>
                                <div class="col-md-6"><button type="submit" id="betETH" class="btn btn-block btn-info bet-btn" data-coin="ETH">Bet on Ethereum</button></div>
                            </div>
                        </form>
                    </div>
                    <div class="col-md-6">
                        <div id="coinflip">
                            <div id="bitcoin"></div>
                            <div id="ethereum"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-12">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title mb-4 text-center">Previous Games</h4>
                <div class="table-responsive">
                    <table class="table table-striped text-center">
                        <thead>
                            <tr>
                                <td scope="col">Game ID</td>
                                <td scope="col">Bet Amount</td>
                                <td scope="col">Bet Coin</td>
                                <td scope="col">Result</td>
                                <td scope="col">Profit</td>
                            </tr>
                        </thead>
                        <tbody id="coinflipHistory">
                            <?php
                            foreach ($history as $flip) {
                                echo '<tr><th scope="row">' . $flip["id"] . '</th><td>' . currencyDisplay($flip['bet_amount'], $settings) . '</td><td>' . strtoupper($flip['coin']) . '</td><td>' . strtoupper($flip['result']) . '</td><td>' . currencyDisplay($flip['profit'], $settings) . '</td></tr>';
                            }
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="ads">
    <?= $settings['coinflip_footer_ad'] ?>
</div>

<script>
    var rate = <?= $settings['currency_rate'] ?>;
</script>