<div class="ads">
    <?= $settings['ptc_top_ad'] ?>
</div>
<!-- notice -->
<div class="row section px-3">
    <div class="col-12">
        <div class="notice-bar">
            <p>You have <span class="fw-bold"><?= format_money($user['dep_balance']) ?></span> in deposit balance. You can deposit or transfer from
                main balance to create ads.</p>
        </div>
    </div>
</div>

<!-- advertise form -->
<div class="row section px-3">
    <div class="col-12">
        <div class="rounded-bg">
        <?php
                if (isset($_SESSION['message'])) {
                    echo $_SESSION['message'];
                } ?>
            <form action="<?= site_url('/advertise/add') ?>" method="POST">
                <!-- name -->
                <label class="form-label fw-bold" for="">Name</label>
                <div class="input-wrap mb-3">
                    <div class="input-icon">
                        <i class="fa-solid fa-globe"></i>
                    </div>
                    <input class="form-input" type="text" name="name" minlength="1" maxlength="75" autocomplete="off" required>
                </div>

                <!-- description -->
                <label class="form-label fw-bold" for="">Description</label>
                <div class="input-wrap mb-3">
                    <div class="input-icon">
                        <i class="fa-regular fa-message"></i>
                    </div>
                    <input class="form-input" type="text" name="description" minlength="1" maxlength="75" autocomplete="off" required>
                </div>

                <!-- url -->
                <label class="form-label fw-bold" for="">URL</label>
                <div class="input-wrap mb-3">
                    <div class="input-icon">
                        <i class="fa-solid fa-link"></i>
                    </div>
                    <input class="form-input" type="text" name="url" autocomplete="off" required>
                </div>

                <!-- url -->
                <label class="form-label fw-bold" for="">View</label>
                <div class="input-wrap mb-3">
                    <div class="input-icon">
                        <i class="fa-solid fa-eye"></i>
                    </div>
                    <input class="form-input" type="number" name="view" min="1" autocomplete="off" required>
                </div>

                <!-- duration -->
                <label class="form-label fw-bold" for="">Duration</label>
                <div class="input-wrap mb-3">
                <select class="form-input" id="option" name="option">
                            <?php foreach ($options as $option) { ?>
                                <option value="<?= $option['id'] ?>"><?= $option['timer'] ?> seconds (<?= currencyDisplay($option['price'], $settings) ?>/view, minimum <?= $option['min_view'] ?> views)</option>
                            <?php } ?>
                        </select>
                </div>

                <?php
                    if ($settings['coupon_status'] == 'on') { ?>
                <!-- cupon code -->
                <label class="form-label fw-bold" for="">Coupon code</label>
                <div class=" input-wrap mb-4">
                            <div class="input-group-prepend">
                            <div class="input-icon">
                        <i class="fa-solid fa-ticket"></i>
                      </div>
                            </div>
                            <input type="text" id="coupon-code" class="form-input" name="code" placeholder="Enter your coupon code" aria-label="Coupon code" aria-describedby="coupon-icon" autocomplete="off">
                            <button class="btn btn-primary waves-effect" id="coupon-check" type="button">Check</button>
                        </div>
                        <div id="coupon-result"></div>

                <?php } ?>
                <input type="hidden" name="<?= $csrf_name ?>" id="token" value="<?= $csrf_hash ?>">
                <button class="btn-one" type="submit">Create Campaign</button>
            </form>
        </div>
    </div>
</div>