<div class="ads">
    <?= $settings['achievements_top_ad'] ?>
</div>
<!-- notice -->
<div class="row section px-3">
    <div class="col-12">
    <?php
                if (isset($_SESSION['message'])) {
                    echo $_SESSION['message'];
                }
                ?>
        <div class="notice-bar">
            <i class="fa-solid fa-circle-exclamation"></i>
            <p>Progress will refresh at <span class="fw-bold">00:00 UTC</span> daily</p>
        </div>
    </div>
</div>

<!-- Achievement table -->
<div class="row section px-3">
    <div class="col-12">
        <div class="rounded-bg">
            <h2 class="title-sm text-center">Achievements</h2>
            <div class="table-responsive">
                <table class="data-table">
                    <thead>
                        <tr>
                            <th>Achievement</th>
                            <th>Reward</th>
                            <th>Progress</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($achievements as $achievement) { ?>
                                <tr>
                                    <td><?= $achievement['description'] ?></td>
                                    <td>
                                        <span class="badge bg-secondary">Token : <?= currencyDisplay($achievement['reward_usd'], $settings) ?></span>
                                        <span class="badge bg-warning"><i class="fas fa-bolt"></i> : <?= $achievement['reward_energy'] ?></span>
                                    </td>
                                    <td>
                                        <div class="progress" style="height: 20px;">
                                            <div class="progress-bar" role="progressbar" style="width: <?= $achievement['progress'] ?>%;" aria-valuenow="<?= $achievement['progress'] ?>" aria-valuemin="0" aria-valuemax="100"><?= $achievement['completed'] ?>/ <?= $achievement['condition'] ?></div>
                                        </div>
                                    </td>
                                    <td>
                                        <form action="<?= site_url('achievements/claim/' . $achievement['id']) ?>" method="POST">
                                            <input type="hidden" name="<?= $csrf_name ?>" value="<?= $csrf_hash ?>">
                                            <?php if ($achievement['completed'] >= $achievement['condition']) { ?>
                                                <button type="submit" class="btn btn-dark mb-2 mr-2 rounded-circle"><i class="far fa-check-circle"></i></button>
                                            <?php } else { ?>
                                                <button disabled type="submit" class="btn btn-dark mb-2 mr-2 rounded-circle"><i class="far fa-check-circle"></i></button>
                                            <?php } ?>
                                        </form>
                                    </td>
                                </tr>
                            <?php } ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<div class="ads">
    <?= $settings['achievements_footer_ad'] ?>
</div>