<div class="row">
    <div class="col-12">
        <div class="page-title-box">
            <div class="page-title-right">
                <a href="<?= site_url('admin/hugoffers') ?>" class="btn btn-outline-primary">
                    <i class="mdi mdi-arrow-left"></i> Back to Offers
                </a>
            </div>
            <h4 class="page-title">Bulk Import HugOffers</h4>
        </div>
    </div>
</div>

<?php if ($this->session->flashdata('message')): ?>
    <?= $this->session->flashdata('message') ?>
<?php endif; ?>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <h4 class="header-title mb-3">Import Multiple Offers</h4>
                <p class="text-muted">
                    Paste your offers list in the format shown below. Each offer should be on separate lines with all details.
                </p>
                
                <form action="<?= site_url('admin/hugoffers/bulk_import') ?>" method="POST">
                    <div class="form-group mb-4">
                        <label for="offers_list" class="form-label">Offers List</label>
                        <textarea class="form-control" id="offers_list" name="offers_list" rows="15" 
                                  placeholder="Paste your offers here..." required></textarea>
                        <small class="form-text text-muted">
                            Each offer should follow the format shown in the example below.
                        </small>
                    </div>
                    
                    <input type="hidden" name="<?= $csrf_name ?>" value="<?= $csrf_hash ?>">
                    <button type="submit" class="btn btn-primary">
                        <i class="mdi mdi-upload"></i> Import Offers
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">Import Format Example</h5>
                <p class="text-muted">Your offers should be formatted like this:</p>
                
                <div class="bg-light p-3 rounded">
                    <pre class="mb-0"><code>[8193]JBO-Apk-Incent-Android
https://88666.one/J122851
PO：$0.4
caps 50

[10345]AX88-APK
https://hypertao.dskbed.xyz/12e0321b60/AX88.apk
PO: $0.4
caps 50

[10374]AALive-VN-CPI-Incent-Android
https://ap12cdn.com/100/140/summer_aalive_236.apk
PO：$0.4
caps 50

[9537]OKBet-PH-Incent-APK
https://okbet.site/hypertap.apk
PO: $0.5
caps: 50

[10317]CPI-AFun-MX-AOS
https://play.google.com/store/apps/details?id=com.afunmx.main.mx
PO: $0.3
caps: 50</code></pre>
                </div>
                
                <div class="mt-3">
                    <h6>Format Explanation:</h6>
                    <ul class="text-muted">
                        <li><strong>[ID]</strong> - Campaign ID in square brackets</li>
                        <li><strong>Offer Name</strong> - Name of the offer (on same line as ID)</li>
                        <li><strong>URL</strong> - Preview/download URL (next line)</li>
                        <li><strong>PO: $X.XX</strong> - Payout amount in USD</li>
                        <li><strong>caps X</strong> - Daily conversion cap</li>
                        <li><strong>Empty line</strong> - Separates each offer</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">Important Notes</h5>
                <div class="alert alert-info">
                    <h6 class="alert-heading">Before Importing:</h6>
                    <ul class="mb-0">
                        <li>Make sure your API key is configured in <a href="<?= site_url('admin/offerwalls') ?>" class="alert-link">Offerwall Settings</a></li>
                        <li>Set your USD conversion rate to match your site currency</li>
                        <li>Check that Campaign IDs don't already exist in your system</li>
                        <li>Verify the payout amounts are correct</li>
                    </ul>
                </div>
                
                <div class="alert alert-warning">
                    <h6 class="alert-heading">During Import:</h6>
                    <ul class="mb-0">
                        <li>The system will attempt to sync additional details from the HugOffers API</li>
                        <li>If API sync fails, offers will be added with basic information</li>
                        <li>You can edit offers later to add missing details</li>
                        <li>Duplicate Campaign IDs will be skipped</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div> 