<?php
defined('BASEPATH') or exit('No direct script access allowed');

class M_daily_streak extends CI_Model
{
    
    	public function get()
	{
		return $this->db->order_by('day','ASC')->get('daily_streaks')->result_array();
	}
	
public function get_streak($user_id)
{
    $streak = $this->db->where('user_id', $user_id)
                       ->get('user_streaks')
                       ->row_array();

    $today = date('Y-m-d');
    $yesterday = date('Y-m-d', strtotime('-1 day'));

    if ($streak) {
        // If last claim not yesterday or today → reset streak
        if ($streak['last_claim'] != $today && $streak['last_claim'] != $yesterday) {
            $streak['current_day'] = 1;
            $streak['last_claim']  = null; // reset claim marker

            $this->db->where('user_id', $user_id)
                     ->update('user_streaks', [
                         'current_day' => 1,
                         'last_claim'  => null
                     ]);
        }
    }

    return $streak;
}


	public function update($id, $reward_usd, $weight)
	{
		$this->db->where('id', $id);
		$this->db->set('reward', $reward_usd);
		$this->db->set('weight', $weight);
		$this->db->update('daily_streaks');
	}
	public function add($day, $reward_usd, $weight)
	{
		$insert = array(
			'day' => 7,
			'reward' => $reward_usd,
			'weight' => $weight
		);
		$this->db->insert('daily_streaks', $insert);
	}
	public function get_req_earnings()
{
    $query = $this->db->get_where('settings', ['name' => 'req_earnings']);
    $row = $query->row_array();
    return $row ? $row['value'] : 0;
}

public function update_req_earnings($value)
{
    $exists = $this->db->get_where('settings', ['name' => 'req_earnings'])->row_array();
    if ($exists) {
        $this->db->where('name', 'req_earnings');
        $this->db->update('settings', ['value' => $value]);
    } else {
        $this->db->insert('settings', ['name' => 'req_earnings', 'value' => $value]);
    }
}
public function get_rewards($user_id = null)
{
    $rewards = $this->db->order_by('day','ASC')->get('daily_streaks')->result_array();
    $highest = $this->db->order_by('reward', 'DESC')->limit(1)->get('daily_streaks')->row_array();
    
    foreach ($rewards as &$reward) {
        if ($reward['day'] == 7) {
            // For day 7, generate weighted random reward
            $reward['reward'] = $this->getWeightedDay7Reward();
        }
    }

    return $rewards;
}

public function get_max_reward()
{
    $row = $this->db
        ->order_by('reward', 'DESC')  // highest reward first
        ->limit(1)                    // only one row
        ->get('daily_streaks')
        ->row_array();

    return $row['reward'] ?? 0;      // return 0 if table empty
}

public function get_min_reward()
{
    $row = $this->db
        ->where('day', 7)             // only day 7 rewards
        ->order_by('reward', 'ASC')   // lowest reward first
        ->limit(1)
        ->get('daily_streaks')
        ->row_array();

    return $row['reward'] ?? 0;       // return 0 if no row found
}

private function getWeightedDay7Reward()
{
    // Fetch all day 7 rows
    $options = $this->db->where('day',7)->get('daily_streaks')->result_array();

    $totalWeight = array_sum(array_column($options,'weight'));
    $rand = mt_rand(1, $totalWeight);

    foreach ($options as $opt) {
        $rand -= $opt['weight'];
        if ($rand <= 0) return $opt['reward'];
    }

    // fallback
    return $options[0]['reward'] ?? 0.5;
}

public function get_day7_probabilities()
{
    // Fetch all day 7 reward options
    $options = $this->db->where('day', 7)->get('daily_streaks')->result_array();

    if (empty($options)) {
        return [];
    }

    // Total weight
    $totalWeight = array_sum(array_column($options, 'weight'));

    $probabilities = [];
    foreach ($options as $opt) {
        $probabilities[] = [
            'reward' => $opt['reward'],
            'weight' => $opt['weight'],
            'chance' => round(($opt['weight'] / $totalWeight) * 100, 3) // % chance with 3 decimals
        ];
    }

    // Sort by chance descending
    usort($probabilities, function($a, $b) {
        return $b['chance'] <=> $a['chance'];
    });

    return $probabilities;
}

public function claim_streak($user_id)
{
    $today = date('Y-m-d');
    $streak = $this->get_streak($user_id);

    if (!$streak) {
        $data = [
            'user_id' => $user_id,
            'current_day' => 1,
            'last_claim' => $today
        ];
        $this->db->insert('user_streaks', $data);
        return $data;
    }

    if ($streak['last_claim'] == $today) {
        return false; // already claimed today
    }

    $yesterday = date('Y-m-d', strtotime('-1 day'));
    if ($streak['last_claim'] == $yesterday) {
        $streak['current_day']++;
        if ($streak['current_day'] > 7) $streak['current_day'] = 1;
    } else {
        $streak['current_day'] = 1; // reset streak
    }

    $streak['last_claim'] = $today;

    $this->db->where('user_id', $user_id)
             ->update('user_streaks', $streak);

    return $streak;
}

}
