<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Offerwalls extends Member_Controller
{
	public function __construct()
	{
		parent::__construct();

		if ($this->data['settings']['offerwall_status'] != 'on') {
			return redirect(site_url('dashboard'));
		}
		if ($this->data['user']['level'] < $this->data['settings']['offerwall_min_level']) {
			return redirect(site_url('dashboard'));
		}
	}

	public function index() {
        $this->data['page'] = 'Offerwalls';
        // Check if Happy Hour is ON
        $happyhour_status = isset($this->data['settings']['happyhour_status']) ? $this->data['settings']['happyhour_status'] : 'off';

        // If Happy Hour is ON, set the end time to 1 hour from now
        $happyhour_end_time = ($happyhour_status == 'on') ? time() + (60 * 60) : null;

        // Pass data to the view
        $this->data['happyhour_status'] = $happyhour_status;
        $this->data['happyhour_end_time'] = $happyhour_end_time;

        // Load the offerwalls view
        $this->render('offerwalls', $this->data);
    }
}
