<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Extralinks extends Member_Controller
{
	public function __construct()
	{
		parent::__construct();
	}

	private function requestWithFileGetContents($url, $token) {
		$options = [
			'http' => [
				'header' => "Content-Type: application/json\r\n" .
                          "Authorization: Bearer " . $token . "\r\n"
			]
		];

		$context = stream_context_create($options);
		return file_get_contents($url, false, $context);
	}

	private function requestWithCurl($url, $token) {
		$ch = curl_init();

		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, [
			'Content-Type: application/json',
			'Authorization: Bearer ' . $token
		]);

		$response = curl_exec($ch);

		if(curl_errno($ch)) {
			$response = false;
		}
		
		curl_close($ch);
		return $response;
	}

	public function index()
	{
		$this->data['page'] = 'Extra Shortlinks';
		
		// BitcoTasks Shortlinks API Integration
		$api_key = 'g523t8kyr2z31fp9lz8j1u5rbhkpic'; // Replace with your actual API key
		$bearer_token = 'a5ac6760456746b50cc9cbee3cd25010e68c78c5e405be198fa0e5abf23801e2'; // Replace with your actual bearer token
		
		// Debug message to check the API URL
		$this->data['debug_url'] = 'https://bitcotasks.com/sl-api/' . $api_key . '/' . $this->data['user']['id'] . '/' . $this->input->ip_address();
		
		// Try CURL first as it's more reliable
		$response = $this->requestWithCurl('https://bitcotasks.com/sl-api/' . $api_key . '/' . $this->data['user']['id'] . '/' . $this->input->ip_address(), $bearer_token);
		
		if ($response === false) {
			// Fall back to file_get_contents if CURL fails
			$response = $this->requestWithFileGetContents('https://bitcotasks.com/sl-api/' . $api_key . '/' . $this->data['user']['id'] . '/' . $this->input->ip_address(), $bearer_token);
		}
		
		if($response) {
			$responseArray = json_decode($response, true);
			$this->data['debug_response'] = $response; // Store raw response for debugging
			
			if(isset($responseArray['status']) && $responseArray['status'] == 200) {
				$this->data['bitcotasks_sl'] = $responseArray['data'];
			} elseif(isset($responseArray['status']) && $responseArray['status'] != 200) {
				$this->data['bitcotasks_error'] = $responseArray['message'];
			} else {
				$this->data['bitcotasks_error'] = 'Invalid response from API';
			}
		} else {
			$this->data['bitcotasks_error'] = 'Failed to connect to BitcoTasks API';
		}
		
		$this->render('extralinks', $this->data);
	}
}